package zio.aws.finspace
import zio.prelude.Subtype
import zio.aws.finspace.model.primitives.{
  SecurityGroupIdString,
  AvailabilityZoneId,
  SubnetIdString,
  DbPath,
  DataBundleArn,
  TagValue,
  FederationAttributeKey,
  FederationAttributeValue,
  TagKey
}
import java.time.Instant
import zio.aws.finspace.model.primitives.SmsDomainUrl.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AutoScalingMetricTarget extends Subtype[Double]
    type AutoScalingMetricTarget =
      zio.aws.finspace.model.primitives.AutoScalingMetricTarget.Type
    object AvailabilityZoneId extends Subtype[String]
    type AvailabilityZoneId =
      zio.aws.finspace.model.primitives.AvailabilityZoneId.Type
    type BoxedInteger = Int
    object ChangesetId extends Subtype[String]
    type ChangesetId = zio.aws.finspace.model.primitives.ChangesetId.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.finspace.model.primitives.ClientToken.Type
    object ClientTokenString extends Subtype[String]
    type ClientTokenString =
      zio.aws.finspace.model.primitives.ClientTokenString.Type
    object CooldownTime extends Subtype[Double]
    type CooldownTime = zio.aws.finspace.model.primitives.CooldownTime.Type
    object DataBundleArn extends Subtype[String]
    type DataBundleArn = zio.aws.finspace.model.primitives.DataBundleArn.Type
    object DatabaseArn extends Subtype[String]
    type DatabaseArn = zio.aws.finspace.model.primitives.DatabaseArn.Type
    object DatabaseName extends Subtype[String]
    type DatabaseName = zio.aws.finspace.model.primitives.DatabaseName.Type
    object DbPath extends Subtype[String]
    type DbPath = zio.aws.finspace.model.primitives.DbPath.Type
    object Description extends Subtype[String]
    type Description = zio.aws.finspace.model.primitives.Description.Type
    object EmailId extends Subtype[String]
    type EmailId = zio.aws.finspace.model.primitives.EmailId.Type
    object EnvironmentArn extends Subtype[String]
    type EnvironmentArn = zio.aws.finspace.model.primitives.EnvironmentArn.Type
    object EnvironmentErrorMessage extends Subtype[String]
    type EnvironmentErrorMessage =
      zio.aws.finspace.model.primitives.EnvironmentErrorMessage.Type
    object EnvironmentId extends Subtype[String]
    type EnvironmentId = zio.aws.finspace.model.primitives.EnvironmentId.Type
    object EnvironmentName extends Subtype[String]
    type EnvironmentName =
      zio.aws.finspace.model.primitives.EnvironmentName.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.finspace.model.primitives.ErrorMessage.Type
    object ExecutionRoleArn extends Subtype[String]
    type ExecutionRoleArn =
      zio.aws.finspace.model.primitives.ExecutionRoleArn.Type
    object FederationAttributeKey extends Subtype[String]
    type FederationAttributeKey =
      zio.aws.finspace.model.primitives.FederationAttributeKey.Type
    object FederationAttributeValue extends Subtype[String]
    type FederationAttributeValue =
      zio.aws.finspace.model.primitives.FederationAttributeValue.Type
    object FederationProviderName extends Subtype[String]
    type FederationProviderName =
      zio.aws.finspace.model.primitives.FederationProviderName.Type
    object FinSpaceTaggableArn extends Subtype[String]
    type FinSpaceTaggableArn =
      zio.aws.finspace.model.primitives.FinSpaceTaggableArn.Type
    object IcmpTypeOrCode extends Subtype[Int]
    type IcmpTypeOrCode = zio.aws.finspace.model.primitives.IcmpTypeOrCode.Type
    object IdType extends Subtype[String]
    type IdType = zio.aws.finspace.model.primitives.IdType.Type
    object InitializationScriptFilePath extends Subtype[String]
    type InitializationScriptFilePath =
      zio.aws.finspace.model.primitives.InitializationScriptFilePath.Type
    object KmsKeyARN extends Subtype[String]
    type KmsKeyARN = zio.aws.finspace.model.primitives.KmsKeyARN.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.finspace.model.primitives.KmsKeyId.Type
    object KxCacheStorageSize extends Subtype[Int]
    type KxCacheStorageSize =
      zio.aws.finspace.model.primitives.KxCacheStorageSize.Type
    object KxCacheStorageType extends Subtype[String]
    type KxCacheStorageType =
      zio.aws.finspace.model.primitives.KxCacheStorageType.Type
    object KxClusterDescription extends Subtype[String]
    type KxClusterDescription =
      zio.aws.finspace.model.primitives.KxClusterDescription.Type
    object KxClusterName extends Subtype[String]
    type KxClusterName = zio.aws.finspace.model.primitives.KxClusterName.Type
    object KxClusterNodeIdString extends Subtype[String]
    type KxClusterNodeIdString =
      zio.aws.finspace.model.primitives.KxClusterNodeIdString.Type
    object KxClusterStatusReason extends Subtype[String]
    type KxClusterStatusReason =
      zio.aws.finspace.model.primitives.KxClusterStatusReason.Type
    object KxCommandLineArgumentKey extends Subtype[String]
    type KxCommandLineArgumentKey =
      zio.aws.finspace.model.primitives.KxCommandLineArgumentKey.Type
    object KxCommandLineArgumentValue extends Subtype[String]
    type KxCommandLineArgumentValue =
      zio.aws.finspace.model.primitives.KxCommandLineArgumentValue.Type
    object KxEnvironmentId extends Subtype[String]
    type KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId.Type
    object KxEnvironmentName extends Subtype[String]
    type KxEnvironmentName =
      zio.aws.finspace.model.primitives.KxEnvironmentName.Type
    object KxSavedownStorageSize extends Subtype[Int]
    type KxSavedownStorageSize =
      zio.aws.finspace.model.primitives.KxSavedownStorageSize.Type
    object KxUserArn extends Subtype[String]
    type KxUserArn = zio.aws.finspace.model.primitives.KxUserArn.Type
    object KxUserNameString extends Subtype[String]
    type KxUserNameString =
      zio.aws.finspace.model.primitives.KxUserNameString.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.finspace.model.primitives.MaxResults.Type
    object NameString extends Subtype[String]
    type NameString = zio.aws.finspace.model.primitives.NameString.Type
    object NodeCount extends Subtype[Int]
    type NodeCount = zio.aws.finspace.model.primitives.NodeCount.Type
    object NodeType extends Subtype[String]
    type NodeType = zio.aws.finspace.model.primitives.NodeType.Type
    object NumBytes extends Subtype[Long]
    type NumBytes = zio.aws.finspace.model.primitives.NumBytes.Type
    object NumChangesets extends Subtype[Int]
    type NumChangesets = zio.aws.finspace.model.primitives.NumChangesets.Type
    object NumFiles extends Subtype[Int]
    type NumFiles = zio.aws.finspace.model.primitives.NumFiles.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.finspace.model.primitives.PaginationToken.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.finspace.model.primitives.Port.Type
    object Protocol extends Subtype[String]
    type Protocol = zio.aws.finspace.model.primitives.Protocol.Type
    object ReleaseLabel extends Subtype[String]
    type ReleaseLabel = zio.aws.finspace.model.primitives.ReleaseLabel.Type
    object ResultLimit extends Subtype[Int]
    type ResultLimit = zio.aws.finspace.model.primitives.ResultLimit.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.finspace.model.primitives.RoleArn.Type
    object RuleNumber extends Subtype[Int]
    type RuleNumber = zio.aws.finspace.model.primitives.RuleNumber.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.finspace.model.primitives.S3Bucket.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.finspace.model.primitives.S3Key.Type
    object S3ObjectVersion extends Subtype[String]
    type S3ObjectVersion =
      zio.aws.finspace.model.primitives.S3ObjectVersion.Type
    object S3Path extends Subtype[String]
    type S3Path = zio.aws.finspace.model.primitives.S3Path.Type
    object SamlMetadataDocument extends Subtype[String]
    type SamlMetadataDocument =
      zio.aws.finspace.model.primitives.SamlMetadataDocument.Type
    object SecurityGroupIdString extends Subtype[String]
    type SecurityGroupIdString =
      zio.aws.finspace.model.primitives.SecurityGroupIdString.Type
    object SignedKxConnectionString extends Subtype[String]
    type SignedKxConnectionString =
      zio.aws.finspace.model.primitives.SignedKxConnectionString.Type
    object SmsDomainUrl extends Subtype[String]
    type SmsDomainUrl = zio.aws.finspace.model.primitives.SmsDomainUrl.Type
    object StringValueLength1to255 extends Subtype[String]
    type StringValueLength1to255 =
      zio.aws.finspace.model.primitives.StringValueLength1to255.Type
    object SubnetIdString extends Subtype[String]
    type SubnetIdString = zio.aws.finspace.model.primitives.SubnetIdString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.finspace.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.finspace.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.finspace.model.primitives.Timestamp.Type
    object TransitGatewayID extends Subtype[String]
    type TransitGatewayID =
      zio.aws.finspace.model.primitives.TransitGatewayID.Type
    object Url extends Subtype[String]
    type Url = zio.aws.finspace.model.primitives.Url.Type
    object Urn extends Subtype[String]
    type Urn = zio.aws.finspace.model.primitives.Urn.Type
    object ValidCIDRBlock extends Subtype[String]
    type ValidCIDRBlock = zio.aws.finspace.model.primitives.ValidCIDRBlock.Type
    object ValidCIDRSpace extends Subtype[String]
    type ValidCIDRSpace = zio.aws.finspace.model.primitives.ValidCIDRSpace.Type
    object ValidHostname extends Subtype[String]
    type ValidHostname = zio.aws.finspace.model.primitives.ValidHostname.Type
    object ValidIPAddress extends Subtype[String]
    type ValidIPAddress = zio.aws.finspace.model.primitives.ValidIPAddress.Type
    object VpcIdString extends Subtype[String]
    type VpcIdString = zio.aws.finspace.model.primitives.VpcIdString.Type
  }
  type AttributeMap = Map[FederationAttributeKey, FederationAttributeValue]
  type AvailabilityZoneIds = List[AvailabilityZoneId]
  type ChangeRequests = List[zio.aws.finspace.model.ChangeRequest]
  type CustomDNSConfiguration = List[zio.aws.finspace.model.CustomDNSServer]
  type DataBundleArns = List[DataBundleArn]
  type DbPaths = List[DbPath]
  type EnvironmentList = List[zio.aws.finspace.model.Environment]
  type KxCacheStorageConfigurations =
    List[zio.aws.finspace.model.KxCacheStorageConfiguration]
  type KxChangesets = List[zio.aws.finspace.model.KxChangesetListEntry]
  type KxClusters = List[zio.aws.finspace.model.KxCluster]
  type KxCommandLineArguments =
    List[zio.aws.finspace.model.KxCommandLineArgument]
  type KxDatabaseCacheConfigurations =
    List[zio.aws.finspace.model.KxDatabaseCacheConfiguration]
  type KxDatabaseConfigurations =
    List[zio.aws.finspace.model.KxDatabaseConfiguration]
  type KxDatabases = List[zio.aws.finspace.model.KxDatabaseListEntry]
  type KxEnvironmentList = List[zio.aws.finspace.model.KxEnvironment]
  type KxNodeSummaries = List[zio.aws.finspace.model.KxNode]
  type KxUserList = List[zio.aws.finspace.model.KxUser]
  type NetworkACLConfiguration = List[zio.aws.finspace.model.NetworkACLEntry]
  type SecurityGroupIdList = List[SecurityGroupIdString]
  type SubnetIdList = List[SubnetIdString]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
