package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{ValidCIDRSpace, TransitGatewayID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayConfiguration(
    transitGatewayID: TransitGatewayID,
    routableCIDRSpace: ValidCIDRSpace,
    attachmentNetworkAclConfiguration: Optional[
      Iterable[zio.aws.finspace.model.NetworkACLEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration = {
    import TransitGatewayConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
      .builder()
      .transitGatewayID(
        TransitGatewayID.unwrap(transitGatewayID): java.lang.String
      )
      .routableCIDRSpace(
        ValidCIDRSpace.unwrap(routableCIDRSpace): java.lang.String
      )
      .optionallyWith(
        attachmentNetworkAclConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentNetworkAclConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly =
    zio.aws.finspace.model.TransitGatewayConfiguration.wrap(buildAwsValue())
}
object TransitGatewayConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.TransitGatewayConfiguration =
      zio.aws.finspace.model.TransitGatewayConfiguration(
        transitGatewayID,
        routableCIDRSpace,
        attachmentNetworkAclConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayID: TransitGatewayID
    def routableCIDRSpace: ValidCIDRSpace
    def attachmentNetworkAclConfiguration
        : Optional[List[zio.aws.finspace.model.NetworkACLEntry.ReadOnly]]
    def getTransitGatewayID: ZIO[Any, Nothing, TransitGatewayID] =
      ZIO.succeed(transitGatewayID)
    def getRoutableCIDRSpace: ZIO[Any, Nothing, ValidCIDRSpace] =
      ZIO.succeed(routableCIDRSpace)
    def getAttachmentNetworkAclConfiguration: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.NetworkACLEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachmentNetworkAclConfiguration",
      attachmentNetworkAclConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
  ) extends zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly {
    override val transitGatewayID: TransitGatewayID =
      zio.aws.finspace.model.primitives
        .TransitGatewayID(impl.transitGatewayID())
    override val routableCIDRSpace: ValidCIDRSpace =
      zio.aws.finspace.model.primitives.ValidCIDRSpace(impl.routableCIDRSpace())
    override val attachmentNetworkAclConfiguration
        : Optional[List[zio.aws.finspace.model.NetworkACLEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentNetworkAclConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.NetworkACLEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration
  ): zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
