package zio.aws.finspace.model
import java.lang.Integer
import zio.ZIO
import zio.aws.finspace.model.primitives.Port
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PortRange(from: Port, to: Port) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.PortRange
      .builder()
      .from(Port.unwrap(from): Integer)
      .to(Port.unwrap(to): Integer)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.PortRange.ReadOnly =
    zio.aws.finspace.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.PortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.PortRange =
      zio.aws.finspace.model.PortRange(from, to)
    def from: Port
    def to: Port
    def getFrom: ZIO[Any, Nothing, Port] = ZIO.succeed(from)
    def getTo: ZIO[Any, Nothing, Port] = ZIO.succeed(to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.PortRange
  ) extends zio.aws.finspace.model.PortRange.ReadOnly {
    override val from: Port =
      zio.aws.finspace.model.primitives.Port(impl.from())
    override val to: Port = zio.aws.finspace.model.primitives.Port(impl.to())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.PortRange
  ): zio.aws.finspace.model.PortRange.ReadOnly = new Wrapper(impl)
}
