package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKxUsersResponse(
    users: Optional[Iterable[zio.aws.finspace.model.KxUser]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxUsersResponse = {
    import ListKxUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxUsersResponse.ReadOnly =
    zio.aws.finspace.model.ListKxUsersResponse.wrap(buildAwsValue())
}
object ListKxUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxUsersResponse =
      zio.aws.finspace.model.ListKxUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Optional[List[zio.aws.finspace.model.KxUser.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.finspace.model.KxUser.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxUsersResponse
  ) extends zio.aws.finspace.model.ListKxUsersResponse.ReadOnly {
    override val users: Optional[List[zio.aws.finspace.model.KxUser.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.KxUser.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxUsersResponse
  ): zio.aws.finspace.model.ListKxUsersResponse.ReadOnly = new Wrapper(impl)
}
