package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  MaxResults,
  PaginationToken,
  EnvironmentId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKxDatabasesRequest(
    environmentId: EnvironmentId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest = {
    import ListKxDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxDatabasesRequest.ReadOnly =
    zio.aws.finspace.model.ListKxDatabasesRequest.wrap(buildAwsValue())
}
object ListKxDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxDatabasesRequest =
      zio.aws.finspace.model.ListKxDatabasesRequest(
        environmentId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def environmentId: EnvironmentId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest
  ) extends zio.aws.finspace.model.ListKxDatabasesRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspace.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest
  ): zio.aws.finspace.model.ListKxDatabasesRequest.ReadOnly = new Wrapper(impl)
}
