package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKxClustersResponse(
    kxClusterSummaries: Optional[Iterable[zio.aws.finspace.model.KxCluster]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxClustersResponse = {
    import ListKxClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxClustersResponse
      .builder()
      .optionallyWith(
        kxClusterSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kxClusterSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxClustersResponse.ReadOnly =
    zio.aws.finspace.model.ListKxClustersResponse.wrap(buildAwsValue())
}
object ListKxClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxClustersResponse =
      zio.aws.finspace.model.ListKxClustersResponse(
        kxClusterSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def kxClusterSummaries
        : Optional[List[zio.aws.finspace.model.KxCluster.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getKxClusterSummaries
        : ZIO[Any, AwsError, List[zio.aws.finspace.model.KxCluster.ReadOnly]] =
      AwsError.unwrapOptionField("kxClusterSummaries", kxClusterSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClustersResponse
  ) extends zio.aws.finspace.model.ListKxClustersResponse.ReadOnly {
    override val kxClusterSummaries
        : Optional[List[zio.aws.finspace.model.KxCluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kxClusterSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.KxCluster.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClustersResponse
  ): zio.aws.finspace.model.ListKxClustersResponse.ReadOnly = new Wrapper(impl)
}
