package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  Timestamp,
  RoleArn,
  KxUserNameString,
  KxUserArn
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class KxUser(
    userArn: Optional[KxUserArn] = Optional.Absent,
    userName: Optional[KxUserNameString] = Optional.Absent,
    iamRole: Optional[RoleArn] = Optional.Absent,
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    updateTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.finspace.model.KxUser = {
    import KxUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxUser
      .builder()
      .optionallyWith(
        userArn.map(value => KxUserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        userName.map(value => KxUserNameString.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        iamRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        updateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxUser.ReadOnly =
    zio.aws.finspace.model.KxUser.wrap(buildAwsValue())
}
object KxUser {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.finspace.model.KxUser] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxUser =
      zio.aws.finspace.model.KxUser(
        userArn.map(value => value),
        userName.map(value => value),
        iamRole.map(value => value),
        createTimestamp.map(value => value),
        updateTimestamp.map(value => value)
      )
    def userArn: Optional[KxUserArn]
    def userName: Optional[KxUserNameString]
    def iamRole: Optional[RoleArn]
    def createTimestamp: Optional[Timestamp]
    def updateTimestamp: Optional[Timestamp]
    def getUserArn: ZIO[Any, AwsError, KxUserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getUserName: ZIO[Any, AwsError, KxUserNameString] =
      AwsError.unwrapOptionField("userName", userName)
    def getIamRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateTimestamp", updateTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxUser
  ) extends zio.aws.finspace.model.KxUser.ReadOnly {
    override val userArn: Optional[KxUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.finspace.model.primitives.KxUserArn(value))
    override val userName: Optional[KxUserNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.finspace.model.primitives.KxUserNameString(value))
    override val iamRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.finspace.model.primitives.RoleArn(value))
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val updateTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxUser
  ): zio.aws.finspace.model.KxUser.ReadOnly = new Wrapper(impl)
}
