package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{Timestamp, DatabaseName}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class KxDatabaseListEntry(
    databaseName: Optional[DatabaseName] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxDatabaseListEntry = {
    import KxDatabaseListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxDatabaseListEntry
      .builder()
      .optionallyWith(
        databaseName.map(value => DatabaseName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxDatabaseListEntry.ReadOnly =
    zio.aws.finspace.model.KxDatabaseListEntry.wrap(buildAwsValue())
}
object KxDatabaseListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxDatabaseListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxDatabaseListEntry =
      zio.aws.finspace.model.KxDatabaseListEntry(
        databaseName.map(value => value),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value)
      )
    def databaseName: Optional[DatabaseName]
    def createdTimestamp: Optional[Timestamp]
    def lastModifiedTimestamp: Optional[Timestamp]
    def getDatabaseName: ZIO[Any, AwsError, DatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxDatabaseListEntry
  ) extends zio.aws.finspace.model.KxDatabaseListEntry.ReadOnly {
    override val databaseName: Optional[DatabaseName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.finspace.model.primitives.DatabaseName(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxDatabaseListEntry
  ): zio.aws.finspace.model.KxDatabaseListEntry.ReadOnly = new Wrapper(impl)
}
