package zio.aws.finspace.model
import java.lang.Integer
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  KxCacheStorageSize,
  KxCacheStorageType
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KxCacheStorageConfiguration(
    `type`: KxCacheStorageType,
    size: KxCacheStorageSize
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration = {
    import KxCacheStorageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration
      .builder()
      .`type`(KxCacheStorageType.unwrap(`type`): java.lang.String)
      .size(KxCacheStorageSize.unwrap(size): Integer)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly =
    zio.aws.finspace.model.KxCacheStorageConfiguration.wrap(buildAwsValue())
}
object KxCacheStorageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxCacheStorageConfiguration =
      zio.aws.finspace.model.KxCacheStorageConfiguration(`type`, size)
    def `type`: KxCacheStorageType
    def size: KxCacheStorageSize
    def getType: ZIO[Any, Nothing, KxCacheStorageType] = ZIO.succeed(`type`)
    def getSize: ZIO[Any, Nothing, KxCacheStorageSize] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration
  ) extends zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly {
    override val `type`: KxCacheStorageType =
      zio.aws.finspace.model.primitives.KxCacheStorageType(impl.`type`())
    override val size: KxCacheStorageSize =
      zio.aws.finspace.model.primitives.KxCacheStorageSize(impl.size())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxCacheStorageConfiguration
  ): zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
