package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  Timestamp,
  NumChangesets,
  NumFiles,
  EnvironmentId,
  Description,
  DatabaseName,
  DatabaseArn,
  ChangesetId,
  NumBytes
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetKxDatabaseResponse(
    databaseName: Optional[DatabaseName] = Optional.Absent,
    databaseArn: Optional[DatabaseArn] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent,
    lastCompletedChangesetId: Optional[ChangesetId] = Optional.Absent,
    numBytes: Optional[NumBytes] = Optional.Absent,
    numChangesets: Optional[NumChangesets] = Optional.Absent,
    numFiles: Optional[NumFiles] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse = {
    import GetKxDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse
      .builder()
      .optionallyWith(
        databaseName.map(value => DatabaseName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        databaseArn.map(value => DatabaseArn.unwrap(value): java.lang.String)
      )(_.databaseArn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        lastCompletedChangesetId.map(value =>
          ChangesetId.unwrap(value): java.lang.String
        )
      )(_.lastCompletedChangesetId)
      .optionallyWith(
        numBytes.map(value => NumBytes.unwrap(value): java.lang.Long)
      )(_.numBytes)
      .optionallyWith(
        numChangesets.map(value => NumChangesets.unwrap(value): Integer)
      )(_.numChangesets)
      .optionallyWith(numFiles.map(value => NumFiles.unwrap(value): Integer))(
        _.numFiles
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly =
    zio.aws.finspace.model.GetKxDatabaseResponse.wrap(buildAwsValue())
}
object GetKxDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxDatabaseResponse =
      zio.aws.finspace.model.GetKxDatabaseResponse(
        databaseName.map(value => value),
        databaseArn.map(value => value),
        environmentId.map(value => value),
        description.map(value => value),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value),
        lastCompletedChangesetId.map(value => value),
        numBytes.map(value => value),
        numChangesets.map(value => value),
        numFiles.map(value => value)
      )
    def databaseName: Optional[DatabaseName]
    def databaseArn: Optional[DatabaseArn]
    def environmentId: Optional[EnvironmentId]
    def description: Optional[Description]
    def createdTimestamp: Optional[Timestamp]
    def lastModifiedTimestamp: Optional[Timestamp]
    def lastCompletedChangesetId: Optional[ChangesetId]
    def numBytes: Optional[NumBytes]
    def numChangesets: Optional[NumChangesets]
    def numFiles: Optional[NumFiles]
    def getDatabaseName: ZIO[Any, AwsError, DatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDatabaseArn: ZIO[Any, AwsError, DatabaseArn] =
      AwsError.unwrapOptionField("databaseArn", databaseArn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getLastCompletedChangesetId: ZIO[Any, AwsError, ChangesetId] = AwsError
      .unwrapOptionField("lastCompletedChangesetId", lastCompletedChangesetId)
    def getNumBytes: ZIO[Any, AwsError, NumBytes] =
      AwsError.unwrapOptionField("numBytes", numBytes)
    def getNumChangesets: ZIO[Any, AwsError, NumChangesets] =
      AwsError.unwrapOptionField("numChangesets", numChangesets)
    def getNumFiles: ZIO[Any, AwsError, NumFiles] =
      AwsError.unwrapOptionField("numFiles", numFiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse
  ) extends zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly {
    override val databaseName: Optional[DatabaseName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.finspace.model.primitives.DatabaseName(value))
    override val databaseArn: Optional[DatabaseArn] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseArn())
      .map(value => zio.aws.finspace.model.primitives.DatabaseArn(value))
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val lastCompletedChangesetId: Optional[ChangesetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastCompletedChangesetId())
        .map(value => zio.aws.finspace.model.primitives.ChangesetId(value))
    override val numBytes: Optional[NumBytes] = zio.aws.core.internal
      .optionalFromNullable(impl.numBytes())
      .map(value => zio.aws.finspace.model.primitives.NumBytes(value))
    override val numChangesets: Optional[NumChangesets] = zio.aws.core.internal
      .optionalFromNullable(impl.numChangesets())
      .map(value => zio.aws.finspace.model.primitives.NumChangesets(value))
    override val numFiles: Optional[NumFiles] = zio.aws.core.internal
      .optionalFromNullable(impl.numFiles())
      .map(value => zio.aws.finspace.model.primitives.NumFiles(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse
  ): zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly = new Wrapper(impl)
}
