package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{KxClusterName, KxEnvironmentId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKxClusterRequest(
    environmentId: KxEnvironmentId,
    clusterName: KxClusterName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxClusterRequest = {
    import GetKxClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxClusterRequest
      .builder()
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxClusterRequest.ReadOnly =
    zio.aws.finspace.model.GetKxClusterRequest.wrap(buildAwsValue())
}
object GetKxClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxClusterRequest =
      zio.aws.finspace.model.GetKxClusterRequest(environmentId, clusterName)
    def environmentId: KxEnvironmentId
    def clusterName: KxClusterName
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxClusterRequest
  ) extends zio.aws.finspace.model.GetKxClusterRequest.ReadOnly {
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxClusterRequest
  ): zio.aws.finspace.model.GetKxClusterRequest.ReadOnly = new Wrapper(impl)
}
