package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.ErrorMessage
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorInfo(
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    errorType: Optional[zio.aws.finspace.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ErrorInfo = {
    import ErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ErrorInfo
      .builder()
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(errorType.map(value => value.unwrap))(_.errorType)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ErrorInfo.ReadOnly =
    zio.aws.finspace.model.ErrorInfo.wrap(buildAwsValue())
}
object ErrorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ErrorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ErrorInfo =
      zio.aws.finspace.model.ErrorInfo(
        errorMessage.map(value => value),
        errorType.map(value => value)
      )
    def errorMessage: Optional[ErrorMessage]
    def errorType: Optional[zio.aws.finspace.model.ErrorDetails]
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorType: ZIO[Any, AwsError, zio.aws.finspace.model.ErrorDetails] =
      AwsError.unwrapOptionField("errorType", errorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ErrorInfo
  ) extends zio.aws.finspace.model.ErrorInfo.ReadOnly {
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.finspace.model.primitives.ErrorMessage(value))
    override val errorType: Optional[zio.aws.finspace.model.ErrorDetails] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorType())
        .map(value => zio.aws.finspace.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ErrorInfo
  ): zio.aws.finspace.model.ErrorInfo.ReadOnly = new Wrapper(impl)
}
