package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientTokenString,
  DatabaseName,
  EnvironmentId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateKxChangesetRequest(
    environmentId: EnvironmentId,
    databaseName: DatabaseName,
    changeRequests: Iterable[zio.aws.finspace.model.ChangeRequest],
    clientToken: ClientTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest = {
    import CreateKxChangesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .changeRequests(changeRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .clientToken(ClientTokenString.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxChangesetRequest.ReadOnly =
    zio.aws.finspace.model.CreateKxChangesetRequest.wrap(buildAwsValue())
}
object CreateKxChangesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxChangesetRequest =
      zio.aws.finspace.model.CreateKxChangesetRequest(
        environmentId,
        databaseName,
        changeRequests.map { item =>
          item.asEditable
        },
        clientToken
      )
    def environmentId: EnvironmentId
    def databaseName: DatabaseName
    def changeRequests: List[zio.aws.finspace.model.ChangeRequest.ReadOnly]
    def clientToken: ClientTokenString
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getChangeRequests: ZIO[Any, Nothing, List[
      zio.aws.finspace.model.ChangeRequest.ReadOnly
    ]] = ZIO.succeed(changeRequests)
    def getClientToken: ZIO[Any, Nothing, ClientTokenString] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest
  ) extends zio.aws.finspace.model.CreateKxChangesetRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
    override val changeRequests
        : List[zio.aws.finspace.model.ChangeRequest.ReadOnly] = impl
      .changeRequests()
      .asScala
      .map { item =>
        zio.aws.finspace.model.ChangeRequest.wrap(item)
      }
      .toList
    override val clientToken: ClientTokenString =
      zio.aws.finspace.model.primitives.ClientTokenString(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest
  ): zio.aws.finspace.model.CreateKxChangesetRequest.ReadOnly = new Wrapper(
    impl
  )
}
