package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{S3ObjectVersion, S3Key, S3Bucket}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodeConfiguration(
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent,
    s3ObjectVersion: Optional[S3ObjectVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CodeConfiguration = {
    import CodeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CodeConfiguration
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        s3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.s3ObjectVersion)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CodeConfiguration.ReadOnly =
    zio.aws.finspace.model.CodeConfiguration.wrap(buildAwsValue())
}
object CodeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CodeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CodeConfiguration =
      zio.aws.finspace.model.CodeConfiguration(
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        s3ObjectVersion.map(value => value)
      )
    def s3Bucket: Optional[S3Bucket]
    def s3Key: Optional[S3Key]
    def s3ObjectVersion: Optional[S3ObjectVersion]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("s3ObjectVersion", s3ObjectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CodeConfiguration
  ) extends zio.aws.finspace.model.CodeConfiguration.ReadOnly {
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.finspace.model.primitives.S3Bucket(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.finspace.model.primitives.S3Key(value))
    override val s3ObjectVersion: Optional[S3ObjectVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ObjectVersion())
        .map(value => zio.aws.finspace.model.primitives.S3ObjectVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CodeConfiguration
  ): zio.aws.finspace.model.CodeConfiguration.ReadOnly = new Wrapper(impl)
}
