package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{NodeCount, NodeType}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CapacityConfiguration(
    nodeType: Optional[NodeType] = Optional.Absent,
    nodeCount: Optional[NodeCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CapacityConfiguration = {
    import CapacityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CapacityConfiguration
      .builder()
      .optionallyWith(
        nodeType.map(value => NodeType.unwrap(value): java.lang.String)
      )(_.nodeType)
      .optionallyWith(nodeCount.map(value => NodeCount.unwrap(value): Integer))(
        _.nodeCount
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CapacityConfiguration.ReadOnly =
    zio.aws.finspace.model.CapacityConfiguration.wrap(buildAwsValue())
}
object CapacityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CapacityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CapacityConfiguration =
      zio.aws.finspace.model.CapacityConfiguration(
        nodeType.map(value => value),
        nodeCount.map(value => value)
      )
    def nodeType: Optional[NodeType]
    def nodeCount: Optional[NodeCount]
    def getNodeType: ZIO[Any, AwsError, NodeType] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNodeCount: ZIO[Any, AwsError, NodeCount] =
      AwsError.unwrapOptionField("nodeCount", nodeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CapacityConfiguration
  ) extends zio.aws.finspace.model.CapacityConfiguration.ReadOnly {
    override val nodeType: Optional[NodeType] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => zio.aws.finspace.model.primitives.NodeType(value))
    override val nodeCount: Optional[NodeCount] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeCount())
      .map(value => zio.aws.finspace.model.primitives.NodeCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CapacityConfiguration
  ): zio.aws.finspace.model.CapacityConfiguration.ReadOnly = new Wrapper(impl)
}
