package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{ClientToken, IdType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKxEnvironmentNetworkRequest(
    environmentId: IdType,
    transitGatewayConfiguration: Optional[
      zio.aws.finspace.model.TransitGatewayConfiguration
    ] = Optional.Absent,
    customDNSConfiguration: Optional[
      Iterable[zio.aws.finspace.model.CustomDNSServer]
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest = {
    import UpdateKxEnvironmentNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        transitGatewayConfiguration.map(value => value.buildAwsValue())
      )(_.transitGatewayConfiguration)
      .optionallyWith(
        customDNSConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customDNSConfiguration)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest.ReadOnly =
    zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest
      .wrap(buildAwsValue())
}
object UpdateKxEnvironmentNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest =
      zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest(
        environmentId,
        transitGatewayConfiguration.map(value => value.asEditable),
        customDNSConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def environmentId: IdType
    def transitGatewayConfiguration
        : Optional[zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly]
    def customDNSConfiguration
        : Optional[List[zio.aws.finspace.model.CustomDNSServer.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getTransitGatewayConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayConfiguration",
      transitGatewayConfiguration
    )
    def getCustomDNSConfiguration: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.CustomDNSServer.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customDNSConfiguration",
      customDNSConfiguration
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest
  ) extends zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val transitGatewayConfiguration: Optional[
      zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayConfiguration())
      .map(value =>
        zio.aws.finspace.model.TransitGatewayConfiguration.wrap(value)
      )
    override val customDNSConfiguration
        : Optional[List[zio.aws.finspace.model.CustomDNSServer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDNSConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.CustomDNSServer.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspace.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest
  ): zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
