package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  Timestamp,
  Description,
  EnvironmentId,
  DatabaseName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateKxDatabaseResponse(
    databaseName: Optional[DatabaseName] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse = {
    import UpdateKxDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse
      .builder()
      .optionallyWith(
        databaseName.map(value => DatabaseName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly =
    zio.aws.finspace.model.UpdateKxDatabaseResponse.wrap(buildAwsValue())
}
object UpdateKxDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateKxDatabaseResponse =
      zio.aws.finspace.model.UpdateKxDatabaseResponse(
        databaseName.map(value => value),
        environmentId.map(value => value),
        description.map(value => value),
        lastModifiedTimestamp.map(value => value)
      )
    def databaseName: Optional[DatabaseName]
    def environmentId: Optional[EnvironmentId]
    def description: Optional[Description]
    def lastModifiedTimestamp: Optional[Timestamp]
    def getDatabaseName: ZIO[Any, AwsError, DatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse
  ) extends zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly {
    override val databaseName: Optional[DatabaseName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.finspace.model.primitives.DatabaseName(value))
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse
  ): zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly = new Wrapper(
    impl
  )
}
