package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  InitializationScriptFilePath,
  ClientTokenString,
  KxClusterName,
  KxEnvironmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKxClusterCodeConfigurationRequest(
    environmentId: KxEnvironmentId,
    clusterName: KxClusterName,
    clientToken: Optional[ClientTokenString] = Optional.Absent,
    code: zio.aws.finspace.model.CodeConfiguration,
    initializationScript: Optional[InitializationScriptFilePath] =
      Optional.Absent,
    commandLineArguments: Optional[
      Iterable[zio.aws.finspace.model.KxCommandLineArgument]
    ] = Optional.Absent,
    deploymentConfiguration: Optional[
      zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest = {
    import UpdateKxClusterCodeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest
      .builder()
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenString.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .code(code.buildAwsValue())
      .optionallyWith(
        initializationScript.map(value =>
          InitializationScriptFilePath.unwrap(value): java.lang.String
        )
      )(_.initializationScript)
      .optionallyWith(
        commandLineArguments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commandLineArguments)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest.ReadOnly =
    zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateKxClusterCodeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest =
      zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest(
        environmentId,
        clusterName,
        clientToken.map(value => value),
        code.asEditable,
        initializationScript.map(value => value),
        commandLineArguments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deploymentConfiguration.map(value => value.asEditable)
      )
    def environmentId: KxEnvironmentId
    def clusterName: KxClusterName
    def clientToken: Optional[ClientTokenString]
    def code: zio.aws.finspace.model.CodeConfiguration.ReadOnly
    def initializationScript: Optional[InitializationScriptFilePath]
    def commandLineArguments
        : Optional[List[zio.aws.finspace.model.KxCommandLineArgument.ReadOnly]]
    def deploymentConfiguration: Optional[
      zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.ReadOnly
    ]
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
    def getClientToken: ZIO[Any, AwsError, ClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCode
        : ZIO[Any, Nothing, zio.aws.finspace.model.CodeConfiguration.ReadOnly] =
      ZIO.succeed(code)
    def getInitializationScript
        : ZIO[Any, AwsError, InitializationScriptFilePath] =
      AwsError.unwrapOptionField("initializationScript", initializationScript)
    def getCommandLineArguments: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxCommandLineArgument.ReadOnly
    ]] =
      AwsError.unwrapOptionField("commandLineArguments", commandLineArguments)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest
  ) extends zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest.ReadOnly {
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
    override val clientToken: Optional[ClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.finspace.model.primitives.ClientTokenString(value)
        )
    override val code: zio.aws.finspace.model.CodeConfiguration.ReadOnly =
      zio.aws.finspace.model.CodeConfiguration.wrap(impl.code())
    override val initializationScript: Optional[InitializationScriptFilePath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationScript())
        .map(value =>
          zio.aws.finspace.model.primitives.InitializationScriptFilePath(value)
        )
    override val commandLineArguments: Optional[
      List[zio.aws.finspace.model.KxCommandLineArgument.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commandLineArguments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxCommandLineArgument.wrap(item)
        }.toList
      )
    override val deploymentConfiguration: Optional[
      zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentConfiguration())
      .map(value =>
        zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest
  ): zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
