package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{BoxedInteger, PaginationToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKxEnvironmentsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest = {
    import ListKxEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxEnvironmentsRequest.ReadOnly =
    zio.aws.finspace.model.ListKxEnvironmentsRequest.wrap(buildAwsValue())
}
object ListKxEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxEnvironmentsRequest =
      zio.aws.finspace.model.ListKxEnvironmentsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[BoxedInteger]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest
  ) extends zio.aws.finspace.model.ListKxEnvironmentsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest
  ): zio.aws.finspace.model.ListKxEnvironmentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
