package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKxClusterNodesResponse(
    nodes: Optional[Iterable[zio.aws.finspace.model.KxNode]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse = {
    import ListKxClusterNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse
      .builder()
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly =
    zio.aws.finspace.model.ListKxClusterNodesResponse.wrap(buildAwsValue())
}
object ListKxClusterNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxClusterNodesResponse =
      zio.aws.finspace.model.ListKxClusterNodesResponse(
        nodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def nodes: Optional[List[zio.aws.finspace.model.KxNode.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getNodes
        : ZIO[Any, AwsError, List[zio.aws.finspace.model.KxNode.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse
  ) extends zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly {
    override val nodes: Optional[List[zio.aws.finspace.model.KxNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.KxNode.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse
  ): zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly = new Wrapper(
    impl
  )
}
