package zio.aws.finspace.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KxDeploymentConfiguration(
    deploymentStrategy: zio.aws.finspace.model.KxDeploymentStrategy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxDeploymentConfiguration = {
    import KxDeploymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxDeploymentConfiguration
      .builder()
      .deploymentStrategy(deploymentStrategy.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxDeploymentConfiguration.ReadOnly =
    zio.aws.finspace.model.KxDeploymentConfiguration.wrap(buildAwsValue())
}
object KxDeploymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxDeploymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxDeploymentConfiguration =
      zio.aws.finspace.model.KxDeploymentConfiguration(deploymentStrategy)
    def deploymentStrategy: zio.aws.finspace.model.KxDeploymentStrategy
    def getDeploymentStrategy
        : ZIO[Any, Nothing, zio.aws.finspace.model.KxDeploymentStrategy] =
      ZIO.succeed(deploymentStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxDeploymentConfiguration
  ) extends zio.aws.finspace.model.KxDeploymentConfiguration.ReadOnly {
    override val deploymentStrategy
        : zio.aws.finspace.model.KxDeploymentStrategy =
      zio.aws.finspace.model.KxDeploymentStrategy
        .wrap(impl.deploymentStrategy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxDeploymentConfiguration
  ): zio.aws.finspace.model.KxDeploymentConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
