package zio.aws.finspace.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KxClusterCodeDeploymentConfiguration(
    deploymentStrategy: zio.aws.finspace.model.KxClusterCodeDeploymentStrategy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentConfiguration = {
    import KxClusterCodeDeploymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentConfiguration
      .builder()
      .deploymentStrategy(deploymentStrategy.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.ReadOnly =
    zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration
      .wrap(buildAwsValue())
}
object KxClusterCodeDeploymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration =
      zio.aws.finspace.model
        .KxClusterCodeDeploymentConfiguration(deploymentStrategy)
    def deploymentStrategy
        : zio.aws.finspace.model.KxClusterCodeDeploymentStrategy
    def getDeploymentStrategy: ZIO[
      Any,
      Nothing,
      zio.aws.finspace.model.KxClusterCodeDeploymentStrategy
    ] = ZIO.succeed(deploymentStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentConfiguration
  ) extends zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.ReadOnly {
    override val deploymentStrategy
        : zio.aws.finspace.model.KxClusterCodeDeploymentStrategy =
      zio.aws.finspace.model.KxClusterCodeDeploymentStrategy
        .wrap(impl.deploymentStrategy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentConfiguration
  ): zio.aws.finspace.model.KxClusterCodeDeploymentConfiguration.ReadOnly =
    new Wrapper(impl)
}
