package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.IdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKxEnvironmentRequest(environmentId: IdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest = {
    import GetKxEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.GetKxEnvironmentRequest.wrap(buildAwsValue())
}
object GetKxEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxEnvironmentRequest =
      zio.aws.finspace.model.GetKxEnvironmentRequest(environmentId)
    def environmentId: IdType
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest
  ) extends zio.aws.finspace.model.GetKxEnvironmentRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest
  ): zio.aws.finspace.model.GetKxEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
