package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait ErrorDetails {
  def unwrap: software.amazon.awssdk.services.finspace.model.ErrorDetails
}
object ErrorDetails {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.ErrorDetails
  ): zio.aws.finspace.model.ErrorDetails = value match {
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.THE_INPUTS_TO_THIS_REQUEST_ARE_INVALID =>
      val r = `The inputs to this request are invalid.`
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.SERVICE_LIMITS_HAVE_BEEN_EXCEEDED =>
      val r = `Service limits have been exceeded.`
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.MISSING_REQUIRED_PERMISSION_TO_PERFORM_THIS_REQUEST =>
      val r = `Missing required permission to perform this request.`
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.ONE_OR_MORE_INPUTS_TO_THIS_REQUEST_WERE_NOT_FOUND =>
      val r = `One or more inputs to this request were not found.`
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.THE_SYSTEM_TEMPORARILY_LACKS_SUFFICIENT_RESOURCES_TO_PROCESS_THE_REQUEST =>
      val r =
        `The system temporarily lacks sufficient resources to process the request.`
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.AN_INTERNAL_ERROR_HAS_OCCURRED =>
      val r = `An internal error has occurred.`
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.finspace.model.ErrorDetails.A_USER_RECOVERABLE_ERROR_HAS_OCCURRED =>
      val r = `A user recoverable error has occurred`
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.UNKNOWN_TO_SDK_VERSION
  }
  case object `The inputs to this request are invalid.`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.THE_INPUTS_TO_THIS_REQUEST_ARE_INVALID
  }
  case object `Service limits have been exceeded.`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.SERVICE_LIMITS_HAVE_BEEN_EXCEEDED
  }
  case object `Missing required permission to perform this request.`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.MISSING_REQUIRED_PERMISSION_TO_PERFORM_THIS_REQUEST
  }
  case object `One or more inputs to this request were not found.`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.ONE_OR_MORE_INPUTS_TO_THIS_REQUEST_WERE_NOT_FOUND
  }
  case object `The system temporarily lacks sufficient resources to process the request.`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.THE_SYSTEM_TEMPORARILY_LACKS_SUFFICIENT_RESOURCES_TO_PROCESS_THE_REQUEST
  }
  case object `An internal error has occurred.`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.AN_INTERNAL_ERROR_HAS_OCCURRED
  }
  case object Cancelled extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.CANCELLED
  }
  case object `A user recoverable error has occurred`
      extends zio.aws.finspace.model.ErrorDetails {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ErrorDetails =
      software.amazon.awssdk.services.finspace.model.ErrorDetails.A_USER_RECOVERABLE_ERROR_HAS_OCCURRED
  }
}
