package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  Timestamp,
  EnvironmentId,
  DatabaseName,
  ChangesetId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateKxChangesetResponse(
    changesetId: Optional[ChangesetId] = Optional.Absent,
    databaseName: Optional[DatabaseName] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    changeRequests: Optional[Iterable[zio.aws.finspace.model.ChangeRequest]] =
      Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.finspace.model.ChangesetStatus] = Optional.Absent,
    errorInfo: Optional[zio.aws.finspace.model.ErrorInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse = {
    import CreateKxChangesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse
      .builder()
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .optionallyWith(
        databaseName.map(value => DatabaseName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        changeRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeRequests)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly =
    zio.aws.finspace.model.CreateKxChangesetResponse.wrap(buildAwsValue())
}
object CreateKxChangesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxChangesetResponse =
      zio.aws.finspace.model.CreateKxChangesetResponse(
        changesetId.map(value => value),
        databaseName.map(value => value),
        environmentId.map(value => value),
        changeRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value),
        status.map(value => value),
        errorInfo.map(value => value.asEditable)
      )
    def changesetId: Optional[ChangesetId]
    def databaseName: Optional[DatabaseName]
    def environmentId: Optional[EnvironmentId]
    def changeRequests
        : Optional[List[zio.aws.finspace.model.ChangeRequest.ReadOnly]]
    def createdTimestamp: Optional[Timestamp]
    def lastModifiedTimestamp: Optional[Timestamp]
    def status: Optional[zio.aws.finspace.model.ChangesetStatus]
    def errorInfo: Optional[zio.aws.finspace.model.ErrorInfo.ReadOnly]
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
    def getDatabaseName: ZIO[Any, AwsError, DatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getChangeRequests: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.ChangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("changeRequests", changeRequests)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getStatus: ZIO[Any, AwsError, zio.aws.finspace.model.ChangesetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorInfo
        : ZIO[Any, AwsError, zio.aws.finspace.model.ErrorInfo.ReadOnly] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse
  ) extends zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly {
    override val changesetId: Optional[ChangesetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetId())
      .map(value => zio.aws.finspace.model.primitives.ChangesetId(value))
    override val databaseName: Optional[DatabaseName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.finspace.model.primitives.DatabaseName(value))
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.EnvironmentId(value))
    override val changeRequests
        : Optional[List[zio.aws.finspace.model.ChangeRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.ChangeRequest.wrap(item)
          }.toList
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.finspace.model.ChangesetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspace.model.ChangesetStatus.wrap(value))
    override val errorInfo
        : Optional[zio.aws.finspace.model.ErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.finspace.model.ErrorInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse
  ): zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly = new Wrapper(
    impl
  )
}
