package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{ValidCIDRBlock, Protocol, RuleNumber}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NetworkACLEntry(
    ruleNumber: RuleNumber,
    protocol: Protocol,
    ruleAction: zio.aws.finspace.model.RuleAction,
    portRange: Optional[zio.aws.finspace.model.PortRange] = Optional.Absent,
    icmpTypeCode: Optional[zio.aws.finspace.model.IcmpTypeCode] =
      Optional.Absent,
    cidrBlock: ValidCIDRBlock
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.NetworkACLEntry = {
    import NetworkACLEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.NetworkACLEntry
      .builder()
      .ruleNumber(RuleNumber.unwrap(ruleNumber): Integer)
      .protocol(Protocol.unwrap(protocol): java.lang.String)
      .ruleAction(ruleAction.unwrap)
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .optionallyWith(icmpTypeCode.map(value => value.buildAwsValue()))(
        _.icmpTypeCode
      )
      .cidrBlock(ValidCIDRBlock.unwrap(cidrBlock): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.NetworkACLEntry.ReadOnly =
    zio.aws.finspace.model.NetworkACLEntry.wrap(buildAwsValue())
}
object NetworkACLEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.NetworkACLEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.NetworkACLEntry =
      zio.aws.finspace.model.NetworkACLEntry(
        ruleNumber,
        protocol,
        ruleAction,
        portRange.map(value => value.asEditable),
        icmpTypeCode.map(value => value.asEditable),
        cidrBlock
      )
    def ruleNumber: RuleNumber
    def protocol: Protocol
    def ruleAction: zio.aws.finspace.model.RuleAction
    def portRange: Optional[zio.aws.finspace.model.PortRange.ReadOnly]
    def icmpTypeCode: Optional[zio.aws.finspace.model.IcmpTypeCode.ReadOnly]
    def cidrBlock: ValidCIDRBlock
    def getRuleNumber: ZIO[Any, Nothing, RuleNumber] = ZIO.succeed(ruleNumber)
    def getProtocol: ZIO[Any, Nothing, Protocol] = ZIO.succeed(protocol)
    def getRuleAction: ZIO[Any, Nothing, zio.aws.finspace.model.RuleAction] =
      ZIO.succeed(ruleAction)
    def getPortRange
        : ZIO[Any, AwsError, zio.aws.finspace.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("portRange", portRange)
    def getIcmpTypeCode
        : ZIO[Any, AwsError, zio.aws.finspace.model.IcmpTypeCode.ReadOnly] =
      AwsError.unwrapOptionField("icmpTypeCode", icmpTypeCode)
    def getCidrBlock: ZIO[Any, Nothing, ValidCIDRBlock] = ZIO.succeed(cidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.NetworkACLEntry
  ) extends zio.aws.finspace.model.NetworkACLEntry.ReadOnly {
    override val ruleNumber: RuleNumber =
      zio.aws.finspace.model.primitives.RuleNumber(impl.ruleNumber())
    override val protocol: Protocol =
      zio.aws.finspace.model.primitives.Protocol(impl.protocol())
    override val ruleAction: zio.aws.finspace.model.RuleAction =
      zio.aws.finspace.model.RuleAction.wrap(impl.ruleAction())
    override val portRange
        : Optional[zio.aws.finspace.model.PortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRange())
        .map(value => zio.aws.finspace.model.PortRange.wrap(value))
    override val icmpTypeCode
        : Optional[zio.aws.finspace.model.IcmpTypeCode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.icmpTypeCode())
        .map(value => zio.aws.finspace.model.IcmpTypeCode.wrap(value))
    override val cidrBlock: ValidCIDRBlock =
      zio.aws.finspace.model.primitives.ValidCIDRBlock(impl.cidrBlock())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.NetworkACLEntry
  ): zio.aws.finspace.model.NetworkACLEntry.ReadOnly = new Wrapper(impl)
}
