package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKxDatabasesResponse(
    kxDatabases: Optional[
      Iterable[zio.aws.finspace.model.KxDatabaseListEntry]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse = {
    import ListKxDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse
      .builder()
      .optionallyWith(
        kxDatabases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kxDatabases)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly =
    zio.aws.finspace.model.ListKxDatabasesResponse.wrap(buildAwsValue())
}
object ListKxDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxDatabasesResponse =
      zio.aws.finspace.model.ListKxDatabasesResponse(
        kxDatabases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def kxDatabases
        : Optional[List[zio.aws.finspace.model.KxDatabaseListEntry.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getKxDatabases: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxDatabaseListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("kxDatabases", kxDatabases)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse
  ) extends zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly {
    override val kxDatabases
        : Optional[List[zio.aws.finspace.model.KxDatabaseListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kxDatabases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.KxDatabaseListEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse
  ): zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly = new Wrapper(impl)
}
