package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  StringValueLength1to255,
  AvailabilityZoneId,
  IdType,
  EnvironmentArn,
  Timestamp,
  KxEnvironmentName,
  KmsKeyId,
  Description,
  EnvironmentErrorMessage
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class KxEnvironment(
    name: Optional[KxEnvironmentName] = Optional.Absent,
    environmentId: Optional[IdType] = Optional.Absent,
    awsAccountId: Optional[IdType] = Optional.Absent,
    status: Optional[zio.aws.finspace.model.EnvironmentStatus] =
      Optional.Absent,
    tgwStatus: Optional[zio.aws.finspace.model.TgwStatus] = Optional.Absent,
    dnsStatus: Optional[zio.aws.finspace.model.DnsStatus] = Optional.Absent,
    errorMessage: Optional[EnvironmentErrorMessage] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentArn: Optional[EnvironmentArn] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    dedicatedServiceAccountId: Optional[IdType] = Optional.Absent,
    transitGatewayConfiguration: Optional[
      zio.aws.finspace.model.TransitGatewayConfiguration
    ] = Optional.Absent,
    customDNSConfiguration: Optional[
      Iterable[zio.aws.finspace.model.CustomDNSServer]
    ] = Optional.Absent,
    creationTimestamp: Optional[Timestamp] = Optional.Absent,
    updateTimestamp: Optional[Timestamp] = Optional.Absent,
    availabilityZoneIds: Optional[Iterable[AvailabilityZoneId]] =
      Optional.Absent,
    certificateAuthorityArn: Optional[StringValueLength1to255] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxEnvironment = {
    import KxEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxEnvironment
      .builder()
      .optionallyWith(
        name.map(value => KxEnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        environmentId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        awsAccountId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(tgwStatus.map(value => value.unwrap))(_.tgwStatus)
      .optionallyWith(dnsStatus.map(value => value.unwrap))(_.dnsStatus)
      .optionallyWith(
        errorMessage.map(value =>
          EnvironmentErrorMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dedicatedServiceAccountId.map(value =>
          IdType.unwrap(value): java.lang.String
        )
      )(_.dedicatedServiceAccountId)
      .optionallyWith(
        transitGatewayConfiguration.map(value => value.buildAwsValue())
      )(_.transitGatewayConfiguration)
      .optionallyWith(
        customDNSConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customDNSConfiguration)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        updateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateTimestamp)
      .optionallyWith(
        availabilityZoneIds.map(value =>
          value.map { item =>
            AvailabilityZoneId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZoneIds)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          StringValueLength1to255.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxEnvironment.ReadOnly =
    zio.aws.finspace.model.KxEnvironment.wrap(buildAwsValue())
}
object KxEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxEnvironment =
      zio.aws.finspace.model.KxEnvironment(
        name.map(value => value),
        environmentId.map(value => value),
        awsAccountId.map(value => value),
        status.map(value => value),
        tgwStatus.map(value => value),
        dnsStatus.map(value => value),
        errorMessage.map(value => value),
        description.map(value => value),
        environmentArn.map(value => value),
        kmsKeyId.map(value => value),
        dedicatedServiceAccountId.map(value => value),
        transitGatewayConfiguration.map(value => value.asEditable),
        customDNSConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTimestamp.map(value => value),
        updateTimestamp.map(value => value),
        availabilityZoneIds.map(value => value),
        certificateAuthorityArn.map(value => value)
      )
    def name: Optional[KxEnvironmentName]
    def environmentId: Optional[IdType]
    def awsAccountId: Optional[IdType]
    def status: Optional[zio.aws.finspace.model.EnvironmentStatus]
    def tgwStatus: Optional[zio.aws.finspace.model.TgwStatus]
    def dnsStatus: Optional[zio.aws.finspace.model.DnsStatus]
    def errorMessage: Optional[EnvironmentErrorMessage]
    def description: Optional[Description]
    def environmentArn: Optional[EnvironmentArn]
    def kmsKeyId: Optional[KmsKeyId]
    def dedicatedServiceAccountId: Optional[IdType]
    def transitGatewayConfiguration
        : Optional[zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly]
    def customDNSConfiguration
        : Optional[List[zio.aws.finspace.model.CustomDNSServer.ReadOnly]]
    def creationTimestamp: Optional[Timestamp]
    def updateTimestamp: Optional[Timestamp]
    def availabilityZoneIds: Optional[List[AvailabilityZoneId]]
    def certificateAuthorityArn: Optional[StringValueLength1to255]
    def getName: ZIO[Any, AwsError, KxEnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getEnvironmentId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getAwsAccountId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspace.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTgwStatus: ZIO[Any, AwsError, zio.aws.finspace.model.TgwStatus] =
      AwsError.unwrapOptionField("tgwStatus", tgwStatus)
    def getDnsStatus: ZIO[Any, AwsError, zio.aws.finspace.model.DnsStatus] =
      AwsError.unwrapOptionField("dnsStatus", dnsStatus)
    def getErrorMessage: ZIO[Any, AwsError, EnvironmentErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDedicatedServiceAccountId: ZIO[Any, AwsError, IdType] = AwsError
      .unwrapOptionField("dedicatedServiceAccountId", dedicatedServiceAccountId)
    def getTransitGatewayConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayConfiguration",
      transitGatewayConfiguration
    )
    def getCustomDNSConfiguration: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.CustomDNSServer.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customDNSConfiguration",
      customDNSConfiguration
    )
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateTimestamp", updateTimestamp)
    def getAvailabilityZoneIds: ZIO[Any, AwsError, List[AvailabilityZoneId]] =
      AwsError.unwrapOptionField("availabilityZoneIds", availabilityZoneIds)
    def getCertificateAuthorityArn
        : ZIO[Any, AwsError, StringValueLength1to255] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxEnvironment
  ) extends zio.aws.finspace.model.KxEnvironment.ReadOnly {
    override val name: Optional[KxEnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.finspace.model.primitives.KxEnvironmentName(value))
    override val environmentId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val awsAccountId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val status: Optional[zio.aws.finspace.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspace.model.EnvironmentStatus.wrap(value))
    override val tgwStatus: Optional[zio.aws.finspace.model.TgwStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tgwStatus())
        .map(value => zio.aws.finspace.model.TgwStatus.wrap(value))
    override val dnsStatus: Optional[zio.aws.finspace.model.DnsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsStatus())
        .map(value => zio.aws.finspace.model.DnsStatus.wrap(value))
    override val errorMessage: Optional[EnvironmentErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value =>
          zio.aws.finspace.model.primitives.EnvironmentErrorMessage(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val environmentArn: Optional[EnvironmentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentArn())
        .map(value => zio.aws.finspace.model.primitives.EnvironmentArn(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.finspace.model.primitives.KmsKeyId(value))
    override val dedicatedServiceAccountId: Optional[IdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedServiceAccountId())
        .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val transitGatewayConfiguration: Optional[
      zio.aws.finspace.model.TransitGatewayConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayConfiguration())
      .map(value =>
        zio.aws.finspace.model.TransitGatewayConfiguration.wrap(value)
      )
    override val customDNSConfiguration
        : Optional[List[zio.aws.finspace.model.CustomDNSServer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDNSConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.CustomDNSServer.wrap(item)
          }.toList
        )
    override val creationTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val updateTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val availabilityZoneIds: Optional[List[AvailabilityZoneId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.primitives.AvailabilityZoneId(item)
          }.toList
        )
    override val certificateAuthorityArn: Optional[StringValueLength1to255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityArn())
        .map(value =>
          zio.aws.finspace.model.primitives.StringValueLength1to255(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxEnvironment
  ): zio.aws.finspace.model.KxEnvironment.ReadOnly = new Wrapper(impl)
}
