package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{ChangesetId, DatabaseName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KxDatabaseConfiguration(
    databaseName: DatabaseName,
    cacheConfigurations: Optional[
      Iterable[zio.aws.finspace.model.KxDatabaseCacheConfiguration]
    ] = Optional.Absent,
    changesetId: Optional[ChangesetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration = {
    import KxDatabaseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration
      .builder()
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .optionallyWith(
        cacheConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheConfigurations)
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly =
    zio.aws.finspace.model.KxDatabaseConfiguration.wrap(buildAwsValue())
}
object KxDatabaseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxDatabaseConfiguration =
      zio.aws.finspace.model.KxDatabaseConfiguration(
        databaseName,
        cacheConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changesetId.map(value => value)
      )
    def databaseName: DatabaseName
    def cacheConfigurations: Optional[
      List[zio.aws.finspace.model.KxDatabaseCacheConfiguration.ReadOnly]
    ]
    def changesetId: Optional[ChangesetId]
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getCacheConfigurations: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxDatabaseCacheConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheConfigurations", cacheConfigurations)
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration
  ) extends zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly {
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
    override val cacheConfigurations: Optional[
      List[zio.aws.finspace.model.KxDatabaseCacheConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxDatabaseCacheConfiguration.wrap(item)
        }.toList
      )
    override val changesetId: Optional[ChangesetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetId())
      .map(value => zio.aws.finspace.model.primitives.ChangesetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration
  ): zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly = new Wrapper(impl)
}
