package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{DbPath, KxCacheStorageType}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KxDatabaseCacheConfiguration(
    cacheType: KxCacheStorageType,
    dbPaths: Iterable[DbPath]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration = {
    import KxDatabaseCacheConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration
      .builder()
      .cacheType(KxCacheStorageType.unwrap(cacheType): java.lang.String)
      .dbPaths(dbPaths.map { item =>
        DbPath.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxDatabaseCacheConfiguration.ReadOnly =
    zio.aws.finspace.model.KxDatabaseCacheConfiguration.wrap(buildAwsValue())
}
object KxDatabaseCacheConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxDatabaseCacheConfiguration =
      zio.aws.finspace.model.KxDatabaseCacheConfiguration(cacheType, dbPaths)
    def cacheType: KxCacheStorageType
    def dbPaths: List[DbPath]
    def getCacheType: ZIO[Any, Nothing, KxCacheStorageType] =
      ZIO.succeed(cacheType)
    def getDbPaths: ZIO[Any, Nothing, List[DbPath]] = ZIO.succeed(dbPaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration
  ) extends zio.aws.finspace.model.KxDatabaseCacheConfiguration.ReadOnly {
    override val cacheType: KxCacheStorageType =
      zio.aws.finspace.model.primitives.KxCacheStorageType(impl.cacheType())
    override val dbPaths: List[DbPath] = impl
      .dbPaths()
      .asScala
      .map { item =>
        zio.aws.finspace.model.primitives.DbPath(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration
  ): zio.aws.finspace.model.KxDatabaseCacheConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
