package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{DatabaseName, EnvironmentId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKxDatabaseRequest(
    environmentId: EnvironmentId,
    databaseName: DatabaseName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest = {
    import GetKxDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxDatabaseRequest.ReadOnly =
    zio.aws.finspace.model.GetKxDatabaseRequest.wrap(buildAwsValue())
}
object GetKxDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxDatabaseRequest =
      zio.aws.finspace.model.GetKxDatabaseRequest(environmentId, databaseName)
    def environmentId: EnvironmentId
    def databaseName: DatabaseName
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest
  ) extends zio.aws.finspace.model.GetKxDatabaseRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest
  ): zio.aws.finspace.model.GetKxDatabaseRequest.ReadOnly = new Wrapper(impl)
}
