package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{KxClusterName, IdType, KxUserArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKxConnectionStringRequest(
    userArn: KxUserArn,
    environmentId: IdType,
    clusterName: KxClusterName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest = {
    import GetKxConnectionStringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest
      .builder()
      .userArn(KxUserArn.unwrap(userArn): java.lang.String)
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetKxConnectionStringRequest.ReadOnly =
    zio.aws.finspace.model.GetKxConnectionStringRequest.wrap(buildAwsValue())
}
object GetKxConnectionStringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetKxConnectionStringRequest =
      zio.aws.finspace.model
        .GetKxConnectionStringRequest(userArn, environmentId, clusterName)
    def userArn: KxUserArn
    def environmentId: IdType
    def clusterName: KxClusterName
    def getUserArn: ZIO[Any, Nothing, KxUserArn] = ZIO.succeed(userArn)
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest
  ) extends zio.aws.finspace.model.GetKxConnectionStringRequest.ReadOnly {
    override val userArn: KxUserArn =
      zio.aws.finspace.model.primitives.KxUserArn(impl.userArn())
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest
  ): zio.aws.finspace.model.GetKxConnectionStringRequest.ReadOnly = new Wrapper(
    impl
  )
}
