package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  Urn,
  SamlMetadataDocument,
  Url,
  FederationProviderName,
  FederationAttributeKey,
  FederationAttributeValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FederationParameters(
    samlMetadataDocument: Optional[SamlMetadataDocument] = Optional.Absent,
    samlMetadataURL: Optional[Url] = Optional.Absent,
    applicationCallBackURL: Optional[Url] = Optional.Absent,
    federationURN: Optional[Urn] = Optional.Absent,
    federationProviderName: Optional[FederationProviderName] = Optional.Absent,
    attributeMap: Optional[
      Map[FederationAttributeKey, FederationAttributeValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.FederationParameters = {
    import FederationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.FederationParameters
      .builder()
      .optionallyWith(
        samlMetadataDocument.map(value =>
          SamlMetadataDocument.unwrap(value): java.lang.String
        )
      )(_.samlMetadataDocument)
      .optionallyWith(
        samlMetadataURL.map(value => Url.unwrap(value): java.lang.String)
      )(_.samlMetadataURL)
      .optionallyWith(
        applicationCallBackURL.map(value => Url.unwrap(value): java.lang.String)
      )(_.applicationCallBackURL)
      .optionallyWith(
        federationURN.map(value => Urn.unwrap(value): java.lang.String)
      )(_.federationURN)
      .optionallyWith(
        federationProviderName.map(value =>
          FederationProviderName.unwrap(value): java.lang.String
        )
      )(_.federationProviderName)
      .optionallyWith(
        attributeMap.map(value =>
          value
            .map({ case (key, value) =>
              (FederationAttributeKey
                .unwrap(key): java.lang.String) -> (FederationAttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributeMap)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.FederationParameters.ReadOnly =
    zio.aws.finspace.model.FederationParameters.wrap(buildAwsValue())
}
object FederationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.FederationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.FederationParameters =
      zio.aws.finspace.model.FederationParameters(
        samlMetadataDocument.map(value => value),
        samlMetadataURL.map(value => value),
        applicationCallBackURL.map(value => value),
        federationURN.map(value => value),
        federationProviderName.map(value => value),
        attributeMap.map(value => value)
      )
    def samlMetadataDocument: Optional[SamlMetadataDocument]
    def samlMetadataURL: Optional[Url]
    def applicationCallBackURL: Optional[Url]
    def federationURN: Optional[Urn]
    def federationProviderName: Optional[FederationProviderName]
    def attributeMap
        : Optional[Map[FederationAttributeKey, FederationAttributeValue]]
    def getSamlMetadataDocument: ZIO[Any, AwsError, SamlMetadataDocument] =
      AwsError.unwrapOptionField("samlMetadataDocument", samlMetadataDocument)
    def getSamlMetadataURL: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("samlMetadataURL", samlMetadataURL)
    def getApplicationCallBackURL: ZIO[Any, AwsError, Url] = AwsError
      .unwrapOptionField("applicationCallBackURL", applicationCallBackURL)
    def getFederationURN: ZIO[Any, AwsError, Urn] =
      AwsError.unwrapOptionField("federationURN", federationURN)
    def getFederationProviderName: ZIO[Any, AwsError, FederationProviderName] =
      AwsError.unwrapOptionField(
        "federationProviderName",
        federationProviderName
      )
    def getAttributeMap: ZIO[Any, AwsError, Map[
      FederationAttributeKey,
      FederationAttributeValue
    ]] = AwsError.unwrapOptionField("attributeMap", attributeMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.FederationParameters
  ) extends zio.aws.finspace.model.FederationParameters.ReadOnly {
    override val samlMetadataDocument: Optional[SamlMetadataDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlMetadataDocument())
        .map(value =>
          zio.aws.finspace.model.primitives.SamlMetadataDocument(value)
        )
    override val samlMetadataURL: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.samlMetadataURL())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
    override val applicationCallBackURL: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationCallBackURL())
      .map(value => zio.aws.finspace.model.primitives.Url(value))
    override val federationURN: Optional[Urn] = zio.aws.core.internal
      .optionalFromNullable(impl.federationURN())
      .map(value => zio.aws.finspace.model.primitives.Urn(value))
    override val federationProviderName: Optional[FederationProviderName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationProviderName())
        .map(value =>
          zio.aws.finspace.model.primitives.FederationProviderName(value)
        )
    override val attributeMap
        : Optional[Map[FederationAttributeKey, FederationAttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.finspace.model.primitives.FederationAttributeKey(
                key
              ) -> zio.aws.finspace.model.primitives
                .FederationAttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.FederationParameters
  ): zio.aws.finspace.model.FederationParameters.ReadOnly = new Wrapper(impl)
}
