package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.IdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteKxEnvironmentRequest(environmentId: IdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest = {
    import DeleteKxEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.DeleteKxEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.DeleteKxEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteKxEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.DeleteKxEnvironmentRequest =
      zio.aws.finspace.model.DeleteKxEnvironmentRequest(environmentId)
    def environmentId: IdType
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest
  ) extends zio.aws.finspace.model.DeleteKxEnvironmentRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest
  ): zio.aws.finspace.model.DeleteKxEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
