package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  InitializationScriptFilePath,
  ExecutionRoleArn,
  AvailabilityZoneId,
  TagValue,
  KxEnvironmentId,
  KxClusterDescription,
  ClientToken,
  ReleaseLabel,
  KxClusterName,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKxClusterRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    environmentId: KxEnvironmentId,
    clusterName: KxClusterName,
    clusterType: zio.aws.finspace.model.KxClusterType,
    databases: Optional[
      Iterable[zio.aws.finspace.model.KxDatabaseConfiguration]
    ] = Optional.Absent,
    cacheStorageConfigurations: Optional[
      Iterable[zio.aws.finspace.model.KxCacheStorageConfiguration]
    ] = Optional.Absent,
    autoScalingConfiguration: Optional[
      zio.aws.finspace.model.AutoScalingConfiguration
    ] = Optional.Absent,
    clusterDescription: Optional[KxClusterDescription] = Optional.Absent,
    capacityConfiguration: zio.aws.finspace.model.CapacityConfiguration,
    releaseLabel: ReleaseLabel,
    vpcConfiguration: Optional[zio.aws.finspace.model.VpcConfiguration] =
      Optional.Absent,
    initializationScript: Optional[InitializationScriptFilePath] =
      Optional.Absent,
    commandLineArguments: Optional[
      Iterable[zio.aws.finspace.model.KxCommandLineArgument]
    ] = Optional.Absent,
    code: Optional[zio.aws.finspace.model.CodeConfiguration] = Optional.Absent,
    executionRole: Optional[ExecutionRoleArn] = Optional.Absent,
    savedownStorageConfiguration: Optional[
      zio.aws.finspace.model.KxSavedownStorageConfiguration
    ] = Optional.Absent,
    azMode: zio.aws.finspace.model.KxAzMode,
    availabilityZoneId: Optional[AvailabilityZoneId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest = {
    import CreateKxClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .clusterType(clusterType.unwrap)
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(
        cacheStorageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheStorageConfigurations)
      .optionallyWith(
        autoScalingConfiguration.map(value => value.buildAwsValue())
      )(_.autoScalingConfiguration)
      .optionallyWith(
        clusterDescription.map(value =>
          KxClusterDescription.unwrap(value): java.lang.String
        )
      )(_.clusterDescription)
      .capacityConfiguration(capacityConfiguration.buildAwsValue())
      .releaseLabel(ReleaseLabel.unwrap(releaseLabel): java.lang.String)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        initializationScript.map(value =>
          InitializationScriptFilePath.unwrap(value): java.lang.String
        )
      )(_.initializationScript)
      .optionallyWith(
        commandLineArguments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commandLineArguments)
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        executionRole.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .optionallyWith(
        savedownStorageConfiguration.map(value => value.buildAwsValue())
      )(_.savedownStorageConfiguration)
      .azMode(azMode.unwrap)
      .optionallyWith(
        availabilityZoneId.map(value =>
          AvailabilityZoneId.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxClusterRequest.ReadOnly =
    zio.aws.finspace.model.CreateKxClusterRequest.wrap(buildAwsValue())
}
object CreateKxClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxClusterRequest =
      zio.aws.finspace.model.CreateKxClusterRequest(
        clientToken.map(value => value),
        environmentId,
        clusterName,
        clusterType,
        databases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheStorageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingConfiguration.map(value => value.asEditable),
        clusterDescription.map(value => value),
        capacityConfiguration.asEditable,
        releaseLabel,
        vpcConfiguration.map(value => value.asEditable),
        initializationScript.map(value => value),
        commandLineArguments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        code.map(value => value.asEditable),
        executionRole.map(value => value),
        savedownStorageConfiguration.map(value => value.asEditable),
        azMode,
        availabilityZoneId.map(value => value),
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def environmentId: KxEnvironmentId
    def clusterName: KxClusterName
    def clusterType: zio.aws.finspace.model.KxClusterType
    def databases: Optional[
      List[zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly]
    ]
    def cacheStorageConfigurations: Optional[
      List[zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly]
    ]
    def autoScalingConfiguration
        : Optional[zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly]
    def clusterDescription: Optional[KxClusterDescription]
    def capacityConfiguration
        : zio.aws.finspace.model.CapacityConfiguration.ReadOnly
    def releaseLabel: ReleaseLabel
    def vpcConfiguration
        : Optional[zio.aws.finspace.model.VpcConfiguration.ReadOnly]
    def initializationScript: Optional[InitializationScriptFilePath]
    def commandLineArguments
        : Optional[List[zio.aws.finspace.model.KxCommandLineArgument.ReadOnly]]
    def code: Optional[zio.aws.finspace.model.CodeConfiguration.ReadOnly]
    def executionRole: Optional[ExecutionRoleArn]
    def savedownStorageConfiguration: Optional[
      zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly
    ]
    def azMode: zio.aws.finspace.model.KxAzMode
    def availabilityZoneId: Optional[AvailabilityZoneId]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
    def getClusterType
        : ZIO[Any, Nothing, zio.aws.finspace.model.KxClusterType] =
      ZIO.succeed(clusterType)
    def getDatabases: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("databases", databases)
    def getCacheStorageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cacheStorageConfigurations",
      cacheStorageConfigurations
    )
    def getAutoScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoScalingConfiguration",
      autoScalingConfiguration
    )
    def getClusterDescription: ZIO[Any, AwsError, KxClusterDescription] =
      AwsError.unwrapOptionField("clusterDescription", clusterDescription)
    def getCapacityConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.finspace.model.CapacityConfiguration.ReadOnly
    ] = ZIO.succeed(capacityConfiguration)
    def getReleaseLabel: ZIO[Any, Nothing, ReleaseLabel] =
      ZIO.succeed(releaseLabel)
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.finspace.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getInitializationScript
        : ZIO[Any, AwsError, InitializationScriptFilePath] =
      AwsError.unwrapOptionField("initializationScript", initializationScript)
    def getCommandLineArguments: ZIO[Any, AwsError, List[
      zio.aws.finspace.model.KxCommandLineArgument.ReadOnly
    ]] =
      AwsError.unwrapOptionField("commandLineArguments", commandLineArguments)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.CodeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getExecutionRole: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getSavedownStorageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "savedownStorageConfiguration",
      savedownStorageConfiguration
    )
    def getAzMode: ZIO[Any, Nothing, zio.aws.finspace.model.KxAzMode] =
      ZIO.succeed(azMode)
    def getAvailabilityZoneId: ZIO[Any, AwsError, AvailabilityZoneId] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest
  ) extends zio.aws.finspace.model.CreateKxClusterRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspace.model.primitives.ClientToken(value))
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
    override val clusterType: zio.aws.finspace.model.KxClusterType =
      zio.aws.finspace.model.KxClusterType.wrap(impl.clusterType())
    override val databases: Optional[
      List[zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.databases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxDatabaseConfiguration.wrap(item)
        }.toList
      )
    override val cacheStorageConfigurations: Optional[
      List[zio.aws.finspace.model.KxCacheStorageConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheStorageConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxCacheStorageConfiguration.wrap(item)
        }.toList
      )
    override val autoScalingConfiguration
        : Optional[zio.aws.finspace.model.AutoScalingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfiguration())
        .map(value =>
          zio.aws.finspace.model.AutoScalingConfiguration.wrap(value)
        )
    override val clusterDescription: Optional[KxClusterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterDescription())
        .map(value =>
          zio.aws.finspace.model.primitives.KxClusterDescription(value)
        )
    override val capacityConfiguration
        : zio.aws.finspace.model.CapacityConfiguration.ReadOnly =
      zio.aws.finspace.model.CapacityConfiguration
        .wrap(impl.capacityConfiguration())
    override val releaseLabel: ReleaseLabel =
      zio.aws.finspace.model.primitives.ReleaseLabel(impl.releaseLabel())
    override val vpcConfiguration
        : Optional[zio.aws.finspace.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.finspace.model.VpcConfiguration.wrap(value))
    override val initializationScript: Optional[InitializationScriptFilePath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationScript())
        .map(value =>
          zio.aws.finspace.model.primitives.InitializationScriptFilePath(value)
        )
    override val commandLineArguments: Optional[
      List[zio.aws.finspace.model.KxCommandLineArgument.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commandLineArguments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspace.model.KxCommandLineArgument.wrap(item)
        }.toList
      )
    override val code
        : Optional[zio.aws.finspace.model.CodeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.finspace.model.CodeConfiguration.wrap(value))
    override val executionRole: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRole())
        .map(value => zio.aws.finspace.model.primitives.ExecutionRoleArn(value))
    override val savedownStorageConfiguration: Optional[
      zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.savedownStorageConfiguration())
      .map(value =>
        zio.aws.finspace.model.KxSavedownStorageConfiguration.wrap(value)
      )
    override val azMode: zio.aws.finspace.model.KxAzMode =
      zio.aws.finspace.model.KxAzMode.wrap(impl.azMode())
    override val availabilityZoneId: Optional[AvailabilityZoneId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneId())
        .map(value =>
          zio.aws.finspace.model.primitives.AvailabilityZoneId(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspace.model.primitives
              .TagKey(key) -> zio.aws.finspace.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest
  ): zio.aws.finspace.model.CreateKxClusterRequest.ReadOnly = new Wrapper(impl)
}
