package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait AutoScalingMetric {
  def unwrap: software.amazon.awssdk.services.finspace.model.AutoScalingMetric
}
object AutoScalingMetric {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.AutoScalingMetric
  ): zio.aws.finspace.model.AutoScalingMetric = value match {
    case software.amazon.awssdk.services.finspace.model.AutoScalingMetric.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.AutoScalingMetric.CPU_UTILIZATION_PERCENTAGE =>
      val r = CPU_UTILIZATION_PERCENTAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.AutoScalingMetric {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.AutoScalingMetric =
      software.amazon.awssdk.services.finspace.model.AutoScalingMetric.UNKNOWN_TO_SDK_VERSION
  }
  case object CPU_UTILIZATION_PERCENTAGE
      extends zio.aws.finspace.model.AutoScalingMetric {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.AutoScalingMetric =
      software.amazon.awssdk.services.finspace.model.AutoScalingMetric.CPU_UTILIZATION_PERCENTAGE
  }
}
