package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientTokenString,
  Description,
  DatabaseName,
  EnvironmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKxDatabaseRequest(
    environmentId: EnvironmentId,
    databaseName: DatabaseName,
    description: Optional[Description] = Optional.Absent,
    clientToken: ClientTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest = {
    import UpdateKxDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .clientToken(ClientTokenString.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UpdateKxDatabaseRequest.ReadOnly =
    zio.aws.finspace.model.UpdateKxDatabaseRequest.wrap(buildAwsValue())
}
object UpdateKxDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateKxDatabaseRequest =
      zio.aws.finspace.model.UpdateKxDatabaseRequest(
        environmentId,
        databaseName,
        description.map(value => value),
        clientToken
      )
    def environmentId: EnvironmentId
    def databaseName: DatabaseName
    def description: Optional[Description]
    def clientToken: ClientTokenString
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, Nothing, ClientTokenString] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest
  ) extends zio.aws.finspace.model.UpdateKxDatabaseRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val clientToken: ClientTokenString =
      zio.aws.finspace.model.primitives.ClientTokenString(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest
  ): zio.aws.finspace.model.UpdateKxDatabaseRequest.ReadOnly = new Wrapper(impl)
}
