package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{TagKey, FinSpaceTaggableArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: FinSpaceTaggableArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UntagResourceRequest
      .builder()
      .resourceArn(FinSpaceTaggableArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UntagResourceRequest.ReadOnly =
    zio.aws.finspace.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UntagResourceRequest =
      zio.aws.finspace.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: FinSpaceTaggableArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, FinSpaceTaggableArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UntagResourceRequest
  ) extends zio.aws.finspace.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: FinSpaceTaggableArn =
      zio.aws.finspace.model.primitives.FinSpaceTaggableArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.finspace.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UntagResourceRequest
  ): zio.aws.finspace.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
