package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{TagValue, TagKey, FinSpaceTaggableArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: FinSpaceTaggableArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.TagResourceRequest
      .builder()
      .resourceArn(FinSpaceTaggableArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.TagResourceRequest.ReadOnly =
    zio.aws.finspace.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.TagResourceRequest =
      zio.aws.finspace.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: FinSpaceTaggableArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, FinSpaceTaggableArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.TagResourceRequest
  ) extends zio.aws.finspace.model.TagResourceRequest.ReadOnly {
    override val resourceArn: FinSpaceTaggableArn =
      zio.aws.finspace.model.primitives.FinSpaceTaggableArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.finspace.model.primitives
          .TagKey(key) -> zio.aws.finspace.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.TagResourceRequest
  ): zio.aws.finspace.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
