package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{IdType, KxUserNameString}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteKxUserRequest(
    userName: KxUserNameString,
    environmentId: IdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest = {
    import DeleteKxUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest
      .builder()
      .userName(KxUserNameString.unwrap(userName): java.lang.String)
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.DeleteKxUserRequest.ReadOnly =
    zio.aws.finspace.model.DeleteKxUserRequest.wrap(buildAwsValue())
}
object DeleteKxUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.DeleteKxUserRequest =
      zio.aws.finspace.model.DeleteKxUserRequest(userName, environmentId)
    def userName: KxUserNameString
    def environmentId: IdType
    def getUserName: ZIO[Any, Nothing, KxUserNameString] = ZIO.succeed(userName)
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest
  ) extends zio.aws.finspace.model.DeleteKxUserRequest.ReadOnly {
    override val userName: KxUserNameString =
      zio.aws.finspace.model.primitives.KxUserNameString(impl.userName())
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest
  ): zio.aws.finspace.model.DeleteKxUserRequest.ReadOnly = new Wrapper(impl)
}
