package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  KmsKeyARN,
  TagValue,
  KxEnvironmentName,
  Description,
  ClientToken,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKxEnvironmentRequest(
    name: KxEnvironmentName,
    description: Optional[Description] = Optional.Absent,
    kmsKeyId: KmsKeyARN,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest = {
    import CreateKxEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest
      .builder()
      .name(KxEnvironmentName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .kmsKeyId(KmsKeyARN.unwrap(kmsKeyId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.CreateKxEnvironmentRequest.wrap(buildAwsValue())
}
object CreateKxEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxEnvironmentRequest =
      zio.aws.finspace.model.CreateKxEnvironmentRequest(
        name,
        description.map(value => value),
        kmsKeyId,
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def name: KxEnvironmentName
    def description: Optional[Description]
    def kmsKeyId: KmsKeyARN
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[ClientToken]
    def getName: ZIO[Any, Nothing, KxEnvironmentName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyARN] = ZIO.succeed(kmsKeyId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest
  ) extends zio.aws.finspace.model.CreateKxEnvironmentRequest.ReadOnly {
    override val name: KxEnvironmentName =
      zio.aws.finspace.model.primitives.KxEnvironmentName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val kmsKeyId: KmsKeyARN =
      zio.aws.finspace.model.primitives.KmsKeyARN(impl.kmsKeyId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspace.model.primitives
              .TagKey(key) -> zio.aws.finspace.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspace.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest
  ): zio.aws.finspace.model.CreateKxEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
