package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  DataBundleArn,
  TagValue,
  EnvironmentName,
  KmsKeyId,
  Description,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentRequest(
    name: EnvironmentName,
    description: Optional[Description] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    federationMode: Optional[zio.aws.finspace.model.FederationMode] =
      Optional.Absent,
    federationParameters: Optional[
      zio.aws.finspace.model.FederationParameters
    ] = Optional.Absent,
    superuserParameters: Optional[zio.aws.finspace.model.SuperuserParameters] =
      Optional.Absent,
    dataBundles: Optional[Iterable[DataBundleArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest
      .builder()
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(federationMode.map(value => value.unwrap))(
        _.federationMode
      )
      .optionallyWith(federationParameters.map(value => value.buildAwsValue()))(
        _.federationParameters
      )
      .optionallyWith(superuserParameters.map(value => value.buildAwsValue()))(
        _.superuserParameters
      )
      .optionallyWith(
        dataBundles.map(value =>
          value.map { item =>
            DataBundleArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataBundles)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.finspace.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateEnvironmentRequest =
      zio.aws.finspace.model.CreateEnvironmentRequest(
        name,
        description.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value => value),
        federationMode.map(value => value),
        federationParameters.map(value => value.asEditable),
        superuserParameters.map(value => value.asEditable),
        dataBundles.map(value => value)
      )
    def name: EnvironmentName
    def description: Optional[Description]
    def kmsKeyId: Optional[KmsKeyId]
    def tags: Optional[Map[TagKey, TagValue]]
    def federationMode: Optional[zio.aws.finspace.model.FederationMode]
    def federationParameters
        : Optional[zio.aws.finspace.model.FederationParameters.ReadOnly]
    def superuserParameters
        : Optional[zio.aws.finspace.model.SuperuserParameters.ReadOnly]
    def dataBundles: Optional[List[DataBundleArn]]
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFederationMode
        : ZIO[Any, AwsError, zio.aws.finspace.model.FederationMode] =
      AwsError.unwrapOptionField("federationMode", federationMode)
    def getFederationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.FederationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("federationParameters", federationParameters)
    def getSuperuserParameters: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.SuperuserParameters.ReadOnly
    ] = AwsError.unwrapOptionField("superuserParameters", superuserParameters)
    def getDataBundles: ZIO[Any, AwsError, List[DataBundleArn]] =
      AwsError.unwrapOptionField("dataBundles", dataBundles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest
  ) extends zio.aws.finspace.model.CreateEnvironmentRequest.ReadOnly {
    override val name: EnvironmentName =
      zio.aws.finspace.model.primitives.EnvironmentName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.finspace.model.primitives.Description(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.finspace.model.primitives.KmsKeyId(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspace.model.primitives
              .TagKey(key) -> zio.aws.finspace.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val federationMode
        : Optional[zio.aws.finspace.model.FederationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationMode())
        .map(value => zio.aws.finspace.model.FederationMode.wrap(value))
    override val federationParameters
        : Optional[zio.aws.finspace.model.FederationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federationParameters())
        .map(value => zio.aws.finspace.model.FederationParameters.wrap(value))
    override val superuserParameters
        : Optional[zio.aws.finspace.model.SuperuserParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.superuserParameters())
        .map(value => zio.aws.finspace.model.SuperuserParameters.wrap(value))
    override val dataBundles: Optional[List[DataBundleArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataBundles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspace.model.primitives.DataBundleArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest
  ): zio.aws.finspace.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
