package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait ChangeType {
  def unwrap: software.amazon.awssdk.services.finspace.model.ChangeType
}
object ChangeType {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.ChangeType
  ): zio.aws.finspace.model.ChangeType = value match {
    case software.amazon.awssdk.services.finspace.model.ChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.ChangeType.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.finspace.model.ChangeType.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangeType =
      software.amazon.awssdk.services.finspace.model.ChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUT extends zio.aws.finspace.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangeType =
      software.amazon.awssdk.services.finspace.model.ChangeType.PUT
  }
  case object DELETE extends zio.aws.finspace.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangeType =
      software.amazon.awssdk.services.finspace.model.ChangeType.DELETE
  }
}
