package zio.aws.finspace
import zio.aws.finspace.model.CreateEnvironmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.finspace.model.{
  DeleteKxUserRequest,
  GetKxDatabaseRequest,
  ListKxEnvironmentsResponse,
  CreateKxUserResponse,
  ListKxClustersResponse,
  GetEnvironmentRequest,
  DeleteKxEnvironmentResponse,
  UpdateKxClusterDatabasesRequest,
  ListEnvironmentsRequest,
  UpdateKxClusterCodeConfigurationRequest,
  ListKxClustersRequest,
  ListKxClusterNodesRequest,
  DeleteKxClusterRequest,
  DeleteKxEnvironmentRequest,
  ListKxClusterNodesResponse,
  UpdateKxDatabaseRequest,
  DeleteKxClusterResponse,
  GetEnvironmentResponse,
  UpdateKxEnvironmentRequest,
  UpdateKxClusterCodeConfigurationResponse,
  ListKxDatabasesRequest,
  UpdateEnvironmentRequest,
  CreateKxChangesetRequest,
  ListKxUsersResponse,
  ListTagsForResourceRequest,
  CreateKxUserRequest,
  CreateKxClusterRequest,
  UpdateKxClusterDatabasesResponse,
  CreateKxClusterResponse,
  CreateKxEnvironmentResponse,
  KxEnvironment,
  GetKxChangesetResponse,
  UpdateEnvironmentResponse,
  CreateKxDatabaseRequest,
  ListTagsForResourceResponse,
  ListKxDatabasesResponse,
  UntagResourceResponse,
  UpdateKxEnvironmentResponse,
  UpdateKxDatabaseResponse,
  GetKxDatabaseResponse,
  UpdateKxEnvironmentNetworkResponse,
  ListKxChangesetsRequest,
  GetKxChangesetRequest,
  GetKxClusterResponse,
  CreateKxChangesetResponse,
  CreateKxDatabaseResponse,
  GetKxClusterRequest,
  DeleteKxDatabaseRequest,
  UntagResourceRequest,
  DeleteKxUserResponse,
  UpdateKxUserRequest,
  GetKxEnvironmentRequest,
  ListKxEnvironmentsRequest,
  CreateEnvironmentRequest,
  CreateKxEnvironmentRequest,
  GetKxUserRequest,
  UpdateKxUserResponse,
  DeleteEnvironmentRequest,
  GetKxUserResponse,
  GetKxConnectionStringRequest,
  TagResourceResponse,
  UpdateKxEnvironmentNetworkRequest,
  ListKxUsersRequest,
  ListEnvironmentsResponse,
  GetKxEnvironmentResponse,
  GetKxConnectionStringResponse,
  CreateEnvironmentResponse,
  TagResourceRequest,
  DeleteEnvironmentResponse,
  ListKxChangesetsResponse,
  DeleteKxDatabaseResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.finspace.{
  FinspaceAsyncClientBuilder,
  FinspaceAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsPublisher
import scala.jdk.CollectionConverters._
trait Finspace extends AspectSupport[Finspace] {
  val api: FinspaceAsyncClient
  def deleteEnvironment(
      request: zio.aws.finspace.model.DeleteEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly]
  def listKxUsers(
      request: zio.aws.finspace.model.ListKxUsersRequest
  ): IO[AwsError, zio.aws.finspace.model.ListKxUsersResponse.ReadOnly]
  def getKxDatabase(
      request: zio.aws.finspace.model.GetKxDatabaseRequest
  ): IO[AwsError, zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly]
  def listKxDatabases(
      request: zio.aws.finspace.model.ListKxDatabasesRequest
  ): IO[AwsError, zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly]
  def getKxConnectionString(
      request: zio.aws.finspace.model.GetKxConnectionStringRequest
  ): IO[AwsError, zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly]
  def updateKxDatabase(
      request: zio.aws.finspace.model.UpdateKxDatabaseRequest
  ): IO[AwsError, zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly]
  def updateKxEnvironment(
      request: zio.aws.finspace.model.UpdateKxEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.UpdateKxEnvironmentResponse.ReadOnly]
  def createEnvironment(
      request: zio.aws.finspace.model.CreateEnvironmentRequest
  ): IO[AwsError, ReadOnly]
  def createKxDatabase(
      request: zio.aws.finspace.model.CreateKxDatabaseRequest
  ): IO[AwsError, zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly]
  def createKxEnvironment(
      request: zio.aws.finspace.model.CreateKxEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly]
  def getEnvironment(
      request: zio.aws.finspace.model.GetEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly]
  def listKxClusters(
      request: zio.aws.finspace.model.ListKxClustersRequest
  ): IO[AwsError, zio.aws.finspace.model.ListKxClustersResponse.ReadOnly]
  def getKxCluster(
      request: zio.aws.finspace.model.GetKxClusterRequest
  ): IO[AwsError, zio.aws.finspace.model.GetKxClusterResponse.ReadOnly]
  def updateKxClusterCodeConfiguration(
      request: zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.finspace.model.UpdateKxClusterCodeConfigurationResponse.ReadOnly
  ]
  def updateKxEnvironmentNetwork(
      request: zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest
  ): IO[
    AwsError,
    zio.aws.finspace.model.UpdateKxEnvironmentNetworkResponse.ReadOnly
  ]
  def createKxCluster(
      request: zio.aws.finspace.model.CreateKxClusterRequest
  ): IO[AwsError, zio.aws.finspace.model.CreateKxClusterResponse.ReadOnly]
  def getKxChangeset(
      request: zio.aws.finspace.model.GetKxChangesetRequest
  ): IO[AwsError, zio.aws.finspace.model.GetKxChangesetResponse.ReadOnly]
  def createKxUser(
      request: zio.aws.finspace.model.CreateKxUserRequest
  ): IO[AwsError, zio.aws.finspace.model.CreateKxUserResponse.ReadOnly]
  def getKxEnvironment(
      request: zio.aws.finspace.model.GetKxEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.GetKxEnvironmentResponse.ReadOnly]
  def createKxChangeset(
      request: zio.aws.finspace.model.CreateKxChangesetRequest
  ): IO[AwsError, zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly]
  def updateKxClusterDatabases(
      request: zio.aws.finspace.model.UpdateKxClusterDatabasesRequest
  ): IO[
    AwsError,
    zio.aws.finspace.model.UpdateKxClusterDatabasesResponse.ReadOnly
  ]
  def updateKxUser(
      request: zio.aws.finspace.model.UpdateKxUserRequest
  ): IO[AwsError, zio.aws.finspace.model.UpdateKxUserResponse.ReadOnly]
  def listEnvironments(
      request: zio.aws.finspace.model.ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.finspace.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.finspace.model.UntagResourceResponse.ReadOnly]
  def listKxClusterNodes(
      request: zio.aws.finspace.model.ListKxClusterNodesRequest
  ): IO[AwsError, zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly]
  def getKxUser(
      request: zio.aws.finspace.model.GetKxUserRequest
  ): IO[AwsError, zio.aws.finspace.model.GetKxUserResponse.ReadOnly]
  def deleteKxDatabase(
      request: zio.aws.finspace.model.DeleteKxDatabaseRequest
  ): IO[AwsError, zio.aws.finspace.model.DeleteKxDatabaseResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.finspace.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.finspace.model.TagResourceRequest
  ): IO[AwsError, zio.aws.finspace.model.TagResourceResponse.ReadOnly]
  def listKxChangesets(
      request: zio.aws.finspace.model.ListKxChangesetsRequest
  ): IO[AwsError, zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly]
  def updateEnvironment(
      request: zio.aws.finspace.model.UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly]
  def deleteKxUser(
      request: zio.aws.finspace.model.DeleteKxUserRequest
  ): IO[AwsError, zio.aws.finspace.model.DeleteKxUserResponse.ReadOnly]
  def deleteKxCluster(
      request: zio.aws.finspace.model.DeleteKxClusterRequest
  ): IO[AwsError, zio.aws.finspace.model.DeleteKxClusterResponse.ReadOnly]
  def listKxEnvironments(
      request: zio.aws.finspace.model.ListKxEnvironmentsRequest
  ): ZStream[Any, AwsError, zio.aws.finspace.model.KxEnvironment.ReadOnly]
  def listKxEnvironmentsPaginated(
      request: zio.aws.finspace.model.ListKxEnvironmentsRequest
  ): IO[AwsError, zio.aws.finspace.model.ListKxEnvironmentsResponse.ReadOnly]
  def deleteKxEnvironment(
      request: zio.aws.finspace.model.DeleteKxEnvironmentRequest
  ): IO[AwsError, zio.aws.finspace.model.DeleteKxEnvironmentResponse.ReadOnly]
}
object Finspace {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Finspace] = customized(
    identity
  )
  def customized(
      customization: FinspaceAsyncClientBuilder => FinspaceAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Finspace] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: FinspaceAsyncClientBuilder => FinspaceAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Finspace] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = FinspaceAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[FinspaceAsyncClient, FinspaceAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[FinspaceAsyncClient, FinspaceAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new FinspaceImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class FinspaceImpl[R](
      override val api: FinspaceAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Finspace
      with AwsServiceBase[R] {
    override val serviceName: String = "Finspace"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FinspaceImpl[R1] = new FinspaceImpl(api, newAspect, r)
    def deleteEnvironment(
        request: zio.aws.finspace.model.DeleteEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[DeleteEnvironmentRequest, DeleteEnvironmentResponse](
        "deleteEnvironment",
        api.deleteEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.DeleteEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listKxUsers(
        request: zio.aws.finspace.model.ListKxUsersRequest
    ): IO[AwsError, zio.aws.finspace.model.ListKxUsersResponse.ReadOnly] =
      asyncRequestResponse[ListKxUsersRequest, ListKxUsersResponse](
        "listKxUsers",
        api.listKxUsers
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.ListKxUsersResponse.wrap)
        .provideEnvironment(r)
    def getKxDatabase(
        request: zio.aws.finspace.model.GetKxDatabaseRequest
    ): IO[AwsError, zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly] =
      asyncRequestResponse[GetKxDatabaseRequest, GetKxDatabaseResponse](
        "getKxDatabase",
        api.getKxDatabase
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetKxDatabaseResponse.wrap)
        .provideEnvironment(r)
    def listKxDatabases(
        request: zio.aws.finspace.model.ListKxDatabasesRequest
    ): IO[AwsError, zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly] =
      asyncRequestResponse[ListKxDatabasesRequest, ListKxDatabasesResponse](
        "listKxDatabases",
        api.listKxDatabases
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.ListKxDatabasesResponse.wrap)
        .provideEnvironment(r)
    def getKxConnectionString(
        request: zio.aws.finspace.model.GetKxConnectionStringRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly
    ] = asyncRequestResponse[
      GetKxConnectionStringRequest,
      GetKxConnectionStringResponse
    ]("getKxConnectionString", api.getKxConnectionString)(
      request.buildAwsValue()
    ).map(zio.aws.finspace.model.GetKxConnectionStringResponse.wrap)
      .provideEnvironment(r)
    def updateKxDatabase(
        request: zio.aws.finspace.model.UpdateKxDatabaseRequest
    ): IO[AwsError, zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly] =
      asyncRequestResponse[UpdateKxDatabaseRequest, UpdateKxDatabaseResponse](
        "updateKxDatabase",
        api.updateKxDatabase
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.UpdateKxDatabaseResponse.wrap)
        .provideEnvironment(r)
    def updateKxEnvironment(
        request: zio.aws.finspace.model.UpdateKxEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.UpdateKxEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateKxEnvironmentRequest,
      UpdateKxEnvironmentResponse
    ]("updateKxEnvironment", api.updateKxEnvironment)(request.buildAwsValue())
      .map(zio.aws.finspace.model.UpdateKxEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def createEnvironment(
        request: zio.aws.finspace.model.CreateEnvironmentRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateEnvironmentRequest, CreateEnvironmentResponse](
        "createEnvironment",
        api.createEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.CreateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createKxDatabase(
        request: zio.aws.finspace.model.CreateKxDatabaseRequest
    ): IO[AwsError, zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly] =
      asyncRequestResponse[CreateKxDatabaseRequest, CreateKxDatabaseResponse](
        "createKxDatabase",
        api.createKxDatabase
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.CreateKxDatabaseResponse.wrap)
        .provideEnvironment(r)
    def createKxEnvironment(
        request: zio.aws.finspace.model.CreateKxEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateKxEnvironmentRequest,
      CreateKxEnvironmentResponse
    ]("createKxEnvironment", api.createKxEnvironment)(request.buildAwsValue())
      .map(zio.aws.finspace.model.CreateKxEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def getEnvironment(
        request: zio.aws.finspace.model.GetEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[GetEnvironmentRequest, GetEnvironmentResponse](
        "getEnvironment",
        api.getEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listKxClusters(
        request: zio.aws.finspace.model.ListKxClustersRequest
    ): IO[AwsError, zio.aws.finspace.model.ListKxClustersResponse.ReadOnly] =
      asyncRequestResponse[ListKxClustersRequest, ListKxClustersResponse](
        "listKxClusters",
        api.listKxClusters
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.ListKxClustersResponse.wrap)
        .provideEnvironment(r)
    def getKxCluster(
        request: zio.aws.finspace.model.GetKxClusterRequest
    ): IO[AwsError, zio.aws.finspace.model.GetKxClusterResponse.ReadOnly] =
      asyncRequestResponse[GetKxClusterRequest, GetKxClusterResponse](
        "getKxCluster",
        api.getKxCluster
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetKxClusterResponse.wrap)
        .provideEnvironment(r)
    def updateKxClusterCodeConfiguration(
        request: zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.UpdateKxClusterCodeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateKxClusterCodeConfigurationRequest,
      UpdateKxClusterCodeConfigurationResponse
    ]("updateKxClusterCodeConfiguration", api.updateKxClusterCodeConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.finspace.model.UpdateKxClusterCodeConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateKxEnvironmentNetwork(
        request: zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.UpdateKxEnvironmentNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateKxEnvironmentNetworkRequest,
      UpdateKxEnvironmentNetworkResponse
    ]("updateKxEnvironmentNetwork", api.updateKxEnvironmentNetwork)(
      request.buildAwsValue()
    ).map(zio.aws.finspace.model.UpdateKxEnvironmentNetworkResponse.wrap)
      .provideEnvironment(r)
    def createKxCluster(
        request: zio.aws.finspace.model.CreateKxClusterRequest
    ): IO[AwsError, zio.aws.finspace.model.CreateKxClusterResponse.ReadOnly] =
      asyncRequestResponse[CreateKxClusterRequest, CreateKxClusterResponse](
        "createKxCluster",
        api.createKxCluster
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.CreateKxClusterResponse.wrap)
        .provideEnvironment(r)
    def getKxChangeset(
        request: zio.aws.finspace.model.GetKxChangesetRequest
    ): IO[AwsError, zio.aws.finspace.model.GetKxChangesetResponse.ReadOnly] =
      asyncRequestResponse[GetKxChangesetRequest, GetKxChangesetResponse](
        "getKxChangeset",
        api.getKxChangeset
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetKxChangesetResponse.wrap)
        .provideEnvironment(r)
    def createKxUser(
        request: zio.aws.finspace.model.CreateKxUserRequest
    ): IO[AwsError, zio.aws.finspace.model.CreateKxUserResponse.ReadOnly] =
      asyncRequestResponse[CreateKxUserRequest, CreateKxUserResponse](
        "createKxUser",
        api.createKxUser
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.CreateKxUserResponse.wrap)
        .provideEnvironment(r)
    def getKxEnvironment(
        request: zio.aws.finspace.model.GetKxEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.GetKxEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[GetKxEnvironmentRequest, GetKxEnvironmentResponse](
        "getKxEnvironment",
        api.getKxEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetKxEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createKxChangeset(
        request: zio.aws.finspace.model.CreateKxChangesetRequest
    ): IO[AwsError, zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly] =
      asyncRequestResponse[CreateKxChangesetRequest, CreateKxChangesetResponse](
        "createKxChangeset",
        api.createKxChangeset
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.CreateKxChangesetResponse.wrap)
        .provideEnvironment(r)
    def updateKxClusterDatabases(
        request: zio.aws.finspace.model.UpdateKxClusterDatabasesRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.UpdateKxClusterDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateKxClusterDatabasesRequest,
      UpdateKxClusterDatabasesResponse
    ]("updateKxClusterDatabases", api.updateKxClusterDatabases)(
      request.buildAwsValue()
    ).map(zio.aws.finspace.model.UpdateKxClusterDatabasesResponse.wrap)
      .provideEnvironment(r)
    def updateKxUser(
        request: zio.aws.finspace.model.UpdateKxUserRequest
    ): IO[AwsError, zio.aws.finspace.model.UpdateKxUserResponse.ReadOnly] =
      asyncRequestResponse[UpdateKxUserRequest, UpdateKxUserResponse](
        "updateKxUser",
        api.updateKxUser
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.UpdateKxUserResponse.wrap)
        .provideEnvironment(r)
    def listEnvironments(
        request: zio.aws.finspace.model.ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[ListEnvironmentsRequest, ListEnvironmentsResponse](
        "listEnvironments",
        api.listEnvironments
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.finspace.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.finspace.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listKxClusterNodes(
        request: zio.aws.finspace.model.ListKxClusterNodesRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListKxClusterNodesRequest,
      ListKxClusterNodesResponse
    ]("listKxClusterNodes", api.listKxClusterNodes)(request.buildAwsValue())
      .map(zio.aws.finspace.model.ListKxClusterNodesResponse.wrap)
      .provideEnvironment(r)
    def getKxUser(
        request: zio.aws.finspace.model.GetKxUserRequest
    ): IO[AwsError, zio.aws.finspace.model.GetKxUserResponse.ReadOnly] =
      asyncRequestResponse[GetKxUserRequest, GetKxUserResponse](
        "getKxUser",
        api.getKxUser
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.GetKxUserResponse.wrap)
        .provideEnvironment(r)
    def deleteKxDatabase(
        request: zio.aws.finspace.model.DeleteKxDatabaseRequest
    ): IO[AwsError, zio.aws.finspace.model.DeleteKxDatabaseResponse.ReadOnly] =
      asyncRequestResponse[DeleteKxDatabaseRequest, DeleteKxDatabaseResponse](
        "deleteKxDatabase",
        api.deleteKxDatabase
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.DeleteKxDatabaseResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.finspace.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.finspace.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.finspace.model.TagResourceRequest
    ): IO[AwsError, zio.aws.finspace.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listKxChangesets(
        request: zio.aws.finspace.model.ListKxChangesetsRequest
    ): IO[AwsError, zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly] =
      asyncRequestResponse[ListKxChangesetsRequest, ListKxChangesetsResponse](
        "listKxChangesets",
        api.listKxChangesets
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.ListKxChangesetsResponse.wrap)
        .provideEnvironment(r)
    def updateEnvironment(
        request: zio.aws.finspace.model.UpdateEnvironmentRequest
    ): IO[AwsError, zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[UpdateEnvironmentRequest, UpdateEnvironmentResponse](
        "updateEnvironment",
        api.updateEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def deleteKxUser(
        request: zio.aws.finspace.model.DeleteKxUserRequest
    ): IO[AwsError, zio.aws.finspace.model.DeleteKxUserResponse.ReadOnly] =
      asyncRequestResponse[DeleteKxUserRequest, DeleteKxUserResponse](
        "deleteKxUser",
        api.deleteKxUser
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.DeleteKxUserResponse.wrap)
        .provideEnvironment(r)
    def deleteKxCluster(
        request: zio.aws.finspace.model.DeleteKxClusterRequest
    ): IO[AwsError, zio.aws.finspace.model.DeleteKxClusterResponse.ReadOnly] =
      asyncRequestResponse[DeleteKxClusterRequest, DeleteKxClusterResponse](
        "deleteKxCluster",
        api.deleteKxCluster
      )(request.buildAwsValue())
        .map(zio.aws.finspace.model.DeleteKxClusterResponse.wrap)
        .provideEnvironment(r)
    def listKxEnvironments(
        request: zio.aws.finspace.model.ListKxEnvironmentsRequest
    ): ZStream[Any, AwsError, zio.aws.finspace.model.KxEnvironment.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListKxEnvironmentsRequest,
        KxEnvironment,
        ListKxEnvironmentsPublisher
      ](
        "listKxEnvironments",
        api.listKxEnvironmentsPaginator,
        _.environments()
      )(request.buildAwsValue())
        .map(item => zio.aws.finspace.model.KxEnvironment.wrap(item))
        .provideEnvironment(r)
    def listKxEnvironmentsPaginated(
        request: zio.aws.finspace.model.ListKxEnvironmentsRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.ListKxEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListKxEnvironmentsRequest,
      ListKxEnvironmentsResponse
    ]("listKxEnvironments", api.listKxEnvironments)(request.buildAwsValue())
      .map(zio.aws.finspace.model.ListKxEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def deleteKxEnvironment(
        request: zio.aws.finspace.model.DeleteKxEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.finspace.model.DeleteKxEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteKxEnvironmentRequest,
      DeleteKxEnvironmentResponse
    ]("deleteKxEnvironment", api.deleteKxEnvironment)(request.buildAwsValue())
      .map(zio.aws.finspace.model.DeleteKxEnvironmentResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: zio.aws.finspace.model.DeleteEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.DeleteEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def listKxUsers(request: zio.aws.finspace.model.ListKxUsersRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListKxUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKxUsers(request))
  def getKxDatabase(request: zio.aws.finspace.model.GetKxDatabaseRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetKxDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKxDatabase(request))
  def listKxDatabases(
      request: zio.aws.finspace.model.ListKxDatabasesRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListKxDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKxDatabases(request))
  def getKxConnectionString(
      request: zio.aws.finspace.model.GetKxConnectionStringRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetKxConnectionStringResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKxConnectionString(request))
  def updateKxDatabase(
      request: zio.aws.finspace.model.UpdateKxDatabaseRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateKxDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKxDatabase(request))
  def updateKxEnvironment(
      request: zio.aws.finspace.model.UpdateKxEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateKxEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKxEnvironment(request))
  def createEnvironment(
      request: zio.aws.finspace.model.CreateEnvironmentRequest
  ): ZIO[zio.aws.finspace.Finspace, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createEnvironment(request))
  def createKxDatabase(
      request: zio.aws.finspace.model.CreateKxDatabaseRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.CreateKxDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKxDatabase(request))
  def createKxEnvironment(
      request: zio.aws.finspace.model.CreateKxEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.CreateKxEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKxEnvironment(request))
  def getEnvironment(
      request: zio.aws.finspace.model.GetEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def listKxClusters(
      request: zio.aws.finspace.model.ListKxClustersRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListKxClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKxClusters(request))
  def getKxCluster(request: zio.aws.finspace.model.GetKxClusterRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetKxClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKxCluster(request))
  def updateKxClusterCodeConfiguration(
      request: zio.aws.finspace.model.UpdateKxClusterCodeConfigurationRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateKxClusterCodeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKxClusterCodeConfiguration(request))
  def updateKxEnvironmentNetwork(
      request: zio.aws.finspace.model.UpdateKxEnvironmentNetworkRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateKxEnvironmentNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKxEnvironmentNetwork(request))
  def createKxCluster(
      request: zio.aws.finspace.model.CreateKxClusterRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.CreateKxClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKxCluster(request))
  def getKxChangeset(
      request: zio.aws.finspace.model.GetKxChangesetRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetKxChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKxChangeset(request))
  def createKxUser(request: zio.aws.finspace.model.CreateKxUserRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.CreateKxUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKxUser(request))
  def getKxEnvironment(
      request: zio.aws.finspace.model.GetKxEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetKxEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKxEnvironment(request))
  def createKxChangeset(
      request: zio.aws.finspace.model.CreateKxChangesetRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.CreateKxChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKxChangeset(request))
  def updateKxClusterDatabases(
      request: zio.aws.finspace.model.UpdateKxClusterDatabasesRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateKxClusterDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKxClusterDatabases(request))
  def updateKxUser(request: zio.aws.finspace.model.UpdateKxUserRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateKxUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKxUser(request))
  def listEnvironments(
      request: zio.aws.finspace.model.ListEnvironmentsRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironments(request))
  def untagResource(request: zio.aws.finspace.model.UntagResourceRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listKxClusterNodes(
      request: zio.aws.finspace.model.ListKxClusterNodesRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListKxClusterNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKxClusterNodes(request))
  def getKxUser(request: zio.aws.finspace.model.GetKxUserRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.GetKxUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKxUser(request))
  def deleteKxDatabase(
      request: zio.aws.finspace.model.DeleteKxDatabaseRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.DeleteKxDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKxDatabase(request))
  def listTagsForResource(
      request: zio.aws.finspace.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.finspace.model.TagResourceRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listKxChangesets(
      request: zio.aws.finspace.model.ListKxChangesetsRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListKxChangesetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKxChangesets(request))
  def updateEnvironment(
      request: zio.aws.finspace.model.UpdateEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def deleteKxUser(request: zio.aws.finspace.model.DeleteKxUserRequest): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.DeleteKxUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKxUser(request))
  def deleteKxCluster(
      request: zio.aws.finspace.model.DeleteKxClusterRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.DeleteKxClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKxCluster(request))
  def listKxEnvironments(
      request: zio.aws.finspace.model.ListKxEnvironmentsRequest
  ): ZStream[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.KxEnvironment.ReadOnly
  ] = ZStream.serviceWithStream(_.listKxEnvironments(request))
  def listKxEnvironmentsPaginated(
      request: zio.aws.finspace.model.ListKxEnvironmentsRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.ListKxEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKxEnvironmentsPaginated(request))
  def deleteKxEnvironment(
      request: zio.aws.finspace.model.DeleteKxEnvironmentRequest
  ): ZIO[
    zio.aws.finspace.Finspace,
    AwsError,
    zio.aws.finspace.model.DeleteKxEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKxEnvironment(request))
}
