package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  MaxResults,
  PaginationToken,
  DatabaseName,
  EnvironmentId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKxChangesetsRequest(
    environmentId: EnvironmentId,
    databaseName: DatabaseName,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest = {
    import ListKxChangesetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxChangesetsRequest.ReadOnly =
    zio.aws.finspace.model.ListKxChangesetsRequest.wrap(buildAwsValue())
}
object ListKxChangesetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxChangesetsRequest =
      zio.aws.finspace.model.ListKxChangesetsRequest(
        environmentId,
        databaseName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def environmentId: EnvironmentId
    def databaseName: DatabaseName
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest
  ) extends zio.aws.finspace.model.ListKxChangesetsRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspace.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest
  ): zio.aws.finspace.model.ListKxChangesetsRequest.ReadOnly = new Wrapper(impl)
}
