package zio.aws.finspace.model
import java.lang.Integer
import zio.ZIO
import zio.aws.finspace.model.primitives.KxSavedownStorageSize
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KxSavedownStorageConfiguration(
    `type`: zio.aws.finspace.model.KxSavedownStorageType,
    size: KxSavedownStorageSize
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration = {
    import KxSavedownStorageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration
      .builder()
      .`type`(`type`.unwrap)
      .size(KxSavedownStorageSize.unwrap(size): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly =
    zio.aws.finspace.model.KxSavedownStorageConfiguration.wrap(buildAwsValue())
}
object KxSavedownStorageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxSavedownStorageConfiguration =
      zio.aws.finspace.model.KxSavedownStorageConfiguration(`type`, size)
    def `type`: zio.aws.finspace.model.KxSavedownStorageType
    def size: KxSavedownStorageSize
    def getType
        : ZIO[Any, Nothing, zio.aws.finspace.model.KxSavedownStorageType] =
      ZIO.succeed(`type`)
    def getSize: ZIO[Any, Nothing, KxSavedownStorageSize] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration
  ) extends zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly {
    override val `type`: zio.aws.finspace.model.KxSavedownStorageType =
      zio.aws.finspace.model.KxSavedownStorageType.wrap(impl.`type`())
    override val size: KxSavedownStorageSize =
      zio.aws.finspace.model.primitives.KxSavedownStorageSize(impl.size())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxSavedownStorageConfiguration
  ): zio.aws.finspace.model.KxSavedownStorageConfiguration.ReadOnly =
    new Wrapper(impl)
}
