package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait IPAddressType {
  def unwrap: software.amazon.awssdk.services.finspace.model.IPAddressType
}
object IPAddressType {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.IPAddressType
  ): zio.aws.finspace.model.IPAddressType = value match {
    case software.amazon.awssdk.services.finspace.model.IPAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.IPAddressType.IP_V4 =>
      val r = IP_V4
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.IPAddressType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.IPAddressType =
      software.amazon.awssdk.services.finspace.model.IPAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object IP_V4 extends zio.aws.finspace.model.IPAddressType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.IPAddressType =
      software.amazon.awssdk.services.finspace.model.IPAddressType.IP_V4
  }
}
