package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait DnsStatus {
  def unwrap: software.amazon.awssdk.services.finspace.model.DnsStatus
}
object DnsStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.DnsStatus
  ): zio.aws.finspace.model.DnsStatus = value match {
    case software.amazon.awssdk.services.finspace.model.DnsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.DnsStatus.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.finspace.model.DnsStatus.UPDATE_REQUESTED =>
      val r = UPDATE_REQUESTED
      r
    case software.amazon.awssdk.services.finspace.model.DnsStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.finspace.model.DnsStatus.FAILED_UPDATE =>
      val r = FAILED_UPDATE
      r
    case software.amazon.awssdk.services.finspace.model.DnsStatus.SUCCESSFULLY_UPDATED =>
      val r = SUCCESSFULLY_UPDATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.DnsStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.DnsStatus =
      software.amazon.awssdk.services.finspace.model.DnsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.finspace.model.DnsStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.DnsStatus =
      software.amazon.awssdk.services.finspace.model.DnsStatus.NONE
  }
  case object UPDATE_REQUESTED extends zio.aws.finspace.model.DnsStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.DnsStatus =
      software.amazon.awssdk.services.finspace.model.DnsStatus.UPDATE_REQUESTED
  }
  case object UPDATING extends zio.aws.finspace.model.DnsStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.DnsStatus =
      software.amazon.awssdk.services.finspace.model.DnsStatus.UPDATING
  }
  case object FAILED_UPDATE extends zio.aws.finspace.model.DnsStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.DnsStatus =
      software.amazon.awssdk.services.finspace.model.DnsStatus.FAILED_UPDATE
  }
  case object SUCCESSFULLY_UPDATED extends zio.aws.finspace.model.DnsStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.DnsStatus =
      software.amazon.awssdk.services.finspace.model.DnsStatus.SUCCESSFULLY_UPDATED
  }
}
