package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  RoleArn,
  IdType,
  KxUserArn,
  KxUserNameString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKxUserResponse(
    userName: Optional[KxUserNameString] = Optional.Absent,
    userArn: Optional[KxUserArn] = Optional.Absent,
    environmentId: Optional[IdType] = Optional.Absent,
    iamRole: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.CreateKxUserResponse = {
    import CreateKxUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.CreateKxUserResponse
      .builder()
      .optionallyWith(
        userName.map(value => KxUserNameString.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        userArn.map(value => KxUserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        environmentId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        iamRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.iamRole)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.CreateKxUserResponse.ReadOnly =
    zio.aws.finspace.model.CreateKxUserResponse.wrap(buildAwsValue())
}
object CreateKxUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.CreateKxUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.CreateKxUserResponse =
      zio.aws.finspace.model.CreateKxUserResponse(
        userName.map(value => value),
        userArn.map(value => value),
        environmentId.map(value => value),
        iamRole.map(value => value)
      )
    def userName: Optional[KxUserNameString]
    def userArn: Optional[KxUserArn]
    def environmentId: Optional[IdType]
    def iamRole: Optional[RoleArn]
    def getUserName: ZIO[Any, AwsError, KxUserNameString] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserArn: ZIO[Any, AwsError, KxUserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getEnvironmentId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getIamRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("iamRole", iamRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxUserResponse
  ) extends zio.aws.finspace.model.CreateKxUserResponse.ReadOnly {
    override val userName: Optional[KxUserNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.finspace.model.primitives.KxUserNameString(value))
    override val userArn: Optional[KxUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.finspace.model.primitives.KxUserArn(value))
    override val environmentId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.finspace.model.primitives.IdType(value))
    override val iamRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.finspace.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.CreateKxUserResponse
  ): zio.aws.finspace.model.CreateKxUserResponse.ReadOnly = new Wrapper(impl)
}
