package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait ChangesetStatus {
  def unwrap: software.amazon.awssdk.services.finspace.model.ChangesetStatus
}
object ChangesetStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.ChangesetStatus
  ): zio.aws.finspace.model.ChangesetStatus = value match {
    case software.amazon.awssdk.services.finspace.model.ChangesetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.ChangesetStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.finspace.model.ChangesetStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.finspace.model.ChangesetStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.finspace.model.ChangesetStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.ChangesetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangesetStatus =
      software.amazon.awssdk.services.finspace.model.ChangesetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.finspace.model.ChangesetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangesetStatus =
      software.amazon.awssdk.services.finspace.model.ChangesetStatus.PENDING
  }
  case object PROCESSING extends zio.aws.finspace.model.ChangesetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangesetStatus =
      software.amazon.awssdk.services.finspace.model.ChangesetStatus.PROCESSING
  }
  case object FAILED extends zio.aws.finspace.model.ChangesetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangesetStatus =
      software.amazon.awssdk.services.finspace.model.ChangesetStatus.FAILED
  }
  case object COMPLETED extends zio.aws.finspace.model.ChangesetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.ChangesetStatus =
      software.amazon.awssdk.services.finspace.model.ChangesetStatus.COMPLETED
  }
}
